/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.Routed;
import karate.com.linecorp.armeria.server.Router;
import karate.com.linecorp.armeria.server.Service;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.SimpleDecoratingHttpService;
import karate.com.linecorp.armeria.server.VirtualHost;
import karate.io.netty.util.AttributeKey;

public final class RouteDecoratingService
implements HttpService {
    private static final AttributeKey<Queue<HttpService>> DECORATOR_KEY = AttributeKey.valueOf(RouteDecoratingService.class, "SERVICE_CHAIN");
    private final Route route;
    private final HttpService decorator;
    @Nullable
    private VirtualHost defaultVirtualHost;

    public static Function<? super HttpService, HttpService> newDecorator(Router<RouteDecoratingService> router, List<RouteDecoratingService> routeDecoratingServices) {
        return delegate -> new InitialDispatcherService((HttpService)delegate, router, routeDecoratingServices);
    }

    public RouteDecoratingService(Route route, String contextPath, Function<? super HttpService, ? extends HttpService> decoratorFunction) {
        this.route = Objects.requireNonNull(route, "route").withPrefix(contextPath);
        this.decorator = Objects.requireNonNull(decoratorFunction, "decoratorFunction").apply(this);
    }

    private RouteDecoratingService(Route route, HttpService decorator) {
        this.route = Objects.requireNonNull(route, "route");
        this.decorator = Objects.requireNonNull(decorator, "decorator");
    }

    public RouteDecoratingService withRoutePrefix(String prefix) {
        return new RouteDecoratingService(this.route.withPrefix(prefix), this.decorator);
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        VirtualHost defaultVirtualHost = cfg.server().config().defaultVirtualHost();
        if (this.defaultVirtualHost == defaultVirtualHost) {
            return;
        }
        this.defaultVirtualHost = defaultVirtualHost;
        this.decorator.serviceAdded(cfg);
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Queue<HttpService> delegates = ctx.attr(DECORATOR_KEY);
        assert (delegates != null);
        HttpService delegate = delegates.poll();
        assert (delegate != null);
        return delegate.serve(ctx, req);
    }

    public Route route() {
        return this.route;
    }

    private HttpService decorator() {
        return this.decorator;
    }

    @Nullable
    public <T extends HttpService> T as(ServiceRequestContext ctx, Class<T> serviceClass) {
        Queue<HttpService> delegates = ctx.attr(DECORATOR_KEY);
        if (delegates == null) {
            return null;
        }
        for (HttpService delegate : delegates) {
            HttpService service = (HttpService)delegate.as(serviceClass);
            if (service == null) continue;
            return (T)service;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("route", this.route).toString();
    }

    public static final class InitialDispatcherService
    extends SimpleDecoratingHttpService {
        private final Router<RouteDecoratingService> router;
        private final List<RouteDecoratingService> routeDecoratingServices;

        InitialDispatcherService(HttpService delegate, Router<RouteDecoratingService> router, List<RouteDecoratingService> routeDecoratingServices) {
            super(delegate);
            this.router = router;
            this.routeDecoratingServices = routeDecoratingServices;
        }

        @Override
        public void serviceAdded(ServiceConfig cfg) throws Exception {
            super.serviceAdded(cfg);
            for (RouteDecoratingService routeDecoratingService : this.routeDecoratingServices) {
                routeDecoratingService.serviceAdded(cfg);
            }
        }

        @Override
        public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
            ArrayDeque<HttpService> serviceChain = new ArrayDeque<HttpService>(4);
            this.router.findAll(ctx.routingContext()).forEach(routed -> {
                if (routed.isPresent()) {
                    serviceChain.add(((RouteDecoratingService)routed.value()).decorator());
                }
            });
            if (serviceChain.isEmpty()) {
                return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
            }
            serviceChain.add((HttpService)this.unwrap());
            HttpService service = (HttpService)serviceChain.poll();
            ctx.setAttr(DECORATOR_KEY, serviceChain);
            assert (service != null);
            return service.serve(ctx, req);
        }

        @Nullable
        public <T extends HttpService> T findService(ServiceRequestContext ctx, Class<? extends T> serviceClass) {
            for (Routed<RouteDecoratingService> routed : this.router.findAll(ctx.routingContext())) {
                HttpService service;
                if (!routed.isPresent() || (service = (HttpService)routed.value().decorator().as(serviceClass)) == null) continue;
                return (T)service;
            }
            return (T)((HttpService)((Service)this.unwrap()).as(serviceClass));
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("router", this.router).add("delegate", this.unwrap()).toString();
        }
    }
}

