/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.internal.common.util.ObjectCollectingUtil;
import karate.com.linecorp.armeria.internal.server.annotation.ClassUtil;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import karate.org.reactivestreams.Publisher;

final class AggregatedResponseConverterFunction
implements ResponseConverterFunction {
    private final ResponseConverterFunction responseConverter;

    AggregatedResponseConverterFunction(ResponseConverterFunction responseConverter) {
        this.responseConverter = responseConverter;
    }

    @Override
    @Nullable
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType contentType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (HttpResponse.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz)) {
            return false;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        CompletableFuture<Object> f;
        if (result instanceof Publisher) {
            f = ObjectCollectingUtil.collectFrom((Publisher)result, ctx);
        } else if (result instanceof Stream) {
            f = ObjectCollectingUtil.collectFrom((Stream)result, ctx.blockingTaskExecutor());
        } else {
            return (HttpResponse)ResponseConverterFunction.fallthrough();
        }
        return HttpResponse.of((CompletableFuture<? extends HttpResponse>)f.thenApply(aggregated -> {
            try {
                return this.responseConverter.convertResponse(ctx, headers, aggregated, trailers);
            }
            catch (Exception ex) {
                return (HttpResponse)Exceptions.throwUnsafely(ex);
            }
        }));
    }
}

