/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Objects;
import karate.com.linecorp.armeria.internal.server.annotation.DefaultValues;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import karate.com.linecorp.armeria.internal.shaded.guava.base.CaseFormat;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.server.annotation.Header;

final class AnnotatedElementNameUtil {
    static String findName(Object nameRetrievalTarget, String value) {
        Objects.requireNonNull(nameRetrievalTarget, "nameRetrievalTarget");
        if (DefaultValues.isSpecified(value)) {
            Preconditions.checkArgument(!value.isEmpty(), "value is empty.");
            return value;
        }
        return AnnotatedElementNameUtil.getName(nameRetrievalTarget);
    }

    static String findName(Header header, Object nameRetrievalTarget) {
        Objects.requireNonNull(nameRetrievalTarget, "nameRetrievalTarget");
        String value = header.value();
        if (DefaultValues.isSpecified(value)) {
            Preconditions.checkArgument(!value.isEmpty(), "value is empty.");
            return value;
        }
        return AnnotatedElementNameUtil.toHeaderName(AnnotatedElementNameUtil.getName(nameRetrievalTarget));
    }

    static String getNameOrDefault(Object element, String defaultName) {
        try {
            return AnnotatedElementNameUtil.getName(element);
        }
        catch (Exception ignored) {
            return defaultName;
        }
    }

    static String getName(Object element) {
        if (element instanceof Parameter) {
            Parameter parameter = (Parameter)element;
            if (!parameter.isNamePresent()) {
                throw new IllegalArgumentException("cannot obtain the name of the parameter or field automatically. Please make sure you compiled your code with '-parameters' option. Alternatively, you could specify the name explicitly in the annotation.");
            }
            return parameter.getName();
        }
        if (element instanceof Field) {
            return ((Field)element).getName();
        }
        throw new IllegalArgumentException("cannot find the name: " + element.getClass().getName());
    }

    static String toHeaderName(String name) {
        Objects.requireNonNull(name, "name");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty.");
        String upperCased = Ascii.toUpperCase(name);
        if (name.equals(upperCased)) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, name);
        }
        String lowerCased = Ascii.toLowerCase(name);
        if (name.equals(lowerCased)) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, name);
        }
        if (name.indexOf(95) >= 0) {
            return lowerCased;
        }
        if (Ascii.isUpperCase(name.charAt(0))) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
    }

    private AnnotatedElementNameUtil() {
    }
}

