/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.internal.server.annotation.DefaultAnnotatedService;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.annotation.AnnotatedService;

public final class AnnotatedServiceElement {
    private final Route route;
    private final DefaultAnnotatedService service;
    private final Function<? super HttpService, ? extends HttpService> decorator;

    AnnotatedServiceElement(Route route, DefaultAnnotatedService service, Function<? super HttpService, ? extends HttpService> decorator) {
        this.route = Objects.requireNonNull(route, "route");
        this.service = Objects.requireNonNull(service, "service");
        this.decorator = Objects.requireNonNull(decorator, "decorator");
    }

    public Route route() {
        return this.route;
    }

    public AnnotatedService service() {
        return this.service;
    }

    public Function<? super HttpService, ? extends HttpService> decorator() {
        return this.decorator;
    }

    public HttpService buildSafeDecoratedService(Function<? super HttpService, ? extends HttpService> localDecorator) {
        HttpService decoratedService = this.decorator.apply(this.service);
        decoratedService = decoratedService.decorate(localDecorator);
        return this.service.withExceptionHandler(decoratedService);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("route", this.route()).add("service", this.service()).add("decorator", this.decorator()).toString();
    }
}

