/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import karate.com.linecorp.armeria.common.DependencyInjector;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpHeadersBuilder;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.server.RouteUtil;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotatedObjectFactory;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotatedServiceElement;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import karate.com.linecorp.armeria.internal.server.annotation.ClassUtil;
import karate.com.linecorp.armeria.internal.server.annotation.DecoratorAnnotationUtil;
import karate.com.linecorp.armeria.internal.server.annotation.DefaultAnnotatedService;
import karate.com.linecorp.armeria.internal.server.annotation.DefaultValues;
import karate.com.linecorp.armeria.internal.server.annotation.KotlinUtil;
import karate.com.linecorp.armeria.internal.server.annotation.ProcessedDocumentationHelper;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.cache.Cache;
import karate.com.linecorp.armeria.internal.shaded.guava.cache.CacheBuilder;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import karate.com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.annotation.AdditionalHeader;
import karate.com.linecorp.armeria.server.annotation.AdditionalTrailer;
import karate.com.linecorp.armeria.server.annotation.Blocking;
import karate.com.linecorp.armeria.server.annotation.Consumes;
import karate.com.linecorp.armeria.server.annotation.Delete;
import karate.com.linecorp.armeria.server.annotation.Description;
import karate.com.linecorp.armeria.server.annotation.ExceptionHandler;
import karate.com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import karate.com.linecorp.armeria.server.annotation.Get;
import karate.com.linecorp.armeria.server.annotation.Head;
import karate.com.linecorp.armeria.server.annotation.MatchesHeader;
import karate.com.linecorp.armeria.server.annotation.MatchesParam;
import karate.com.linecorp.armeria.server.annotation.Options;
import karate.com.linecorp.armeria.server.annotation.Order;
import karate.com.linecorp.armeria.server.annotation.Patch;
import karate.com.linecorp.armeria.server.annotation.Path;
import karate.com.linecorp.armeria.server.annotation.PathPrefix;
import karate.com.linecorp.armeria.server.annotation.Post;
import karate.com.linecorp.armeria.server.annotation.Produces;
import karate.com.linecorp.armeria.server.annotation.Put;
import karate.com.linecorp.armeria.server.annotation.RequestConverter;
import karate.com.linecorp.armeria.server.annotation.RequestConverterFunction;
import karate.com.linecorp.armeria.server.annotation.RequestObject;
import karate.com.linecorp.armeria.server.annotation.ResponseConverter;
import karate.com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import karate.com.linecorp.armeria.server.annotation.StatusCode;
import karate.com.linecorp.armeria.server.annotation.Trace;
import karate.com.linecorp.armeria.server.docs.DescriptionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedServiceFactory.class);
    private static final Cache<String, Properties> DOCUMENTATION_PROPERTIES_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private static final Map<Class<?>, HttpMethod> HTTP_METHOD_MAP = ImmutableMap.builder().put(Options.class, HttpMethod.OPTIONS).put(Get.class, HttpMethod.GET).put(Head.class, HttpMethod.HEAD).put(Post.class, HttpMethod.POST).put(Put.class, HttpMethod.PUT).put(Patch.class, HttpMethod.PATCH).put(Delete.class, HttpMethod.DELETE).put(Trace.class, HttpMethod.TRACE).build();

    public static List<AnnotatedServiceElement> find(String pathPrefix, Object object, boolean useBlockingTaskExecutor, List<RequestConverterFunction> requestConverterFunctions, List<ResponseConverterFunction> responseConverterFunctions, List<ExceptionHandlerFunction> exceptionHandlerFunctions, DependencyInjector dependencyInjector, @Nullable String queryDelimiter) {
        List<Method> methods = AnnotatedServiceFactory.requestMappingMethods(object);
        ImmutableList.Builder builder = ImmutableList.builder();
        HashMap<String, Integer> overloadIds = new HashMap<String, Integer>();
        for (Method method : methods) {
            String methodName = method.getName();
            int overloadId = overloadIds.containsKey(methodName) ? (Integer)overloadIds.get(methodName) + 1 : 0;
            overloadIds.put(methodName, overloadId);
            builder.addAll(AnnotatedServiceFactory.create(pathPrefix, object, method, overloadId, useBlockingTaskExecutor, requestConverterFunctions, responseConverterFunctions, exceptionHandlerFunctions, dependencyInjector, queryDelimiter));
        }
        return builder.build();
    }

    private static HttpStatus defaultResponseStatus(Method method, Class<?> clazz) {
        List<Produces> producesAnnotations;
        boolean isVoidReturnType;
        StatusCode statusCodeAnnotation = AnnotationUtil.findFirst(method, StatusCode.class);
        if (statusCodeAnnotation != null) {
            return HttpStatus.valueOf(statusCodeAnnotation.value());
        }
        Class<?> returnType = ClassUtil.typeToClass(ClassUtil.unwrapAsyncType(method.getGenericReturnType()));
        boolean bl = isVoidReturnType = returnType == Void.class || returnType == Void.TYPE || KotlinUtil.isSuspendingAndReturnTypeUnit(method);
        if (isVoidReturnType && !(producesAnnotations = AnnotationUtil.findAll(method, Produces.class)).isEmpty()) {
            logger.warn("The following @Produces annotations '{}' for '{}.{}' will be ignored because the return type is void.", new Object[]{producesAnnotations, clazz.getSimpleName(), method.getName()});
        }
        return isVoidReturnType ? HttpStatus.NO_CONTENT : HttpStatus.OK;
    }

    private static <T extends Annotation> void setAdditionalHeader(HttpHeadersBuilder headers, AnnotatedElement element, String clsAlias, String elementAlias, String level, Class<T> annotation, Function<T, String> nameGetter, Function<T, String[]> valueGetter) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(element, "element");
        Objects.requireNonNull(level, "level");
        HashSet addedHeaderSets = new HashSet();
        AnnotationUtil.findAll(element, annotation).forEach(header -> {
            String name = (String)nameGetter.apply(header);
            String[] value = (String[])valueGetter.apply(header);
            if (addedHeaderSets.contains(name)) {
                logger.warn("The additional {} named '{}' at '{}' is set at the same {} level already;ignoring.", new Object[]{clsAlias, name, elementAlias, level});
                return;
            }
            headers.set((CharSequence)HttpHeaderNames.of(name), value);
            addedHeaderSets.add(name);
        });
    }

    static List<AnnotatedServiceElement> create(String pathPrefix, Object object, Method method, int overloadId, boolean useBlockingTaskExecutor, List<RequestConverterFunction> baseRequestConverters, List<ResponseConverterFunction> baseResponseConverters, List<ExceptionHandlerFunction> baseExceptionHandlers, DependencyInjector dependencyInjector, @Nullable String queryDelimiter) {
        if (KotlinUtil.getCallKotlinSuspendingMethod() == null && KotlinUtil.maybeSuspendingFunction(method)) {
            throw new IllegalArgumentException("Kotlin suspending functions are supported only when you added 'armeria-kotlin' as a dependency.\nSee https://armeria.dev/docs/server-annotated-service#kotlin-coroutines-support for more information.");
        }
        Class<?> clazz = object.getClass();
        List<Route> routes = AnnotatedServiceFactory.routes(method, clazz, pathPrefix);
        ImmutableCollection req = ((ImmutableList.Builder)AnnotationUtil.getAnnotatedInstances(method, clazz, RequestConverter.class, RequestConverterFunction.class, dependencyInjector).addAll(baseRequestConverters)).build();
        ImmutableCollection res = ((ImmutableList.Builder)AnnotationUtil.getAnnotatedInstances(method, clazz, ResponseConverter.class, ResponseConverterFunction.class, dependencyInjector).addAll(baseResponseConverters)).build();
        ImmutableCollection eh = ((ImmutableList.Builder)AnnotationUtil.getAnnotatedInstances(method, clazz, ExceptionHandler.class, ExceptionHandlerFunction.class, dependencyInjector).addAll(baseExceptionHandlers)).build();
        String classAlias = clazz.getName();
        String methodAlias = String.format("%s.%s()", classAlias, method.getName());
        HttpHeaders responseHeaders = AnnotatedServiceFactory.responseHeaders(method, clazz, classAlias, methodAlias);
        HttpHeaders responseTrailers = AnnotatedServiceFactory.responseTrailers(method, clazz, classAlias, methodAlias);
        HttpStatus defaultStatus = AnnotatedServiceFactory.defaultResponseStatus(method, clazz);
        if (defaultStatus.isContentAlwaysEmpty() && !responseTrailers.isEmpty()) {
            logger.warn("A response with HTTP status code '{}' cannot have a content. Trailers defined at '{}' might be ignored if HTTP/1.1 is used.", (Object)defaultStatus.code(), (Object)methodAlias);
        }
        boolean needToUseBlockingTaskExecutor = AnnotatedServiceFactory.needToUseBlockingTaskExecutor(object, method, useBlockingTaskExecutor);
        return routes.stream().map(arg_0 -> AnnotatedServiceFactory.lambda$create$1((List)((Object)req), method, clazz, needToUseBlockingTaskExecutor, dependencyInjector, queryDelimiter, object, overloadId, (List)((Object)eh), (List)((Object)res), defaultStatus, responseHeaders, responseTrailers, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private static List<Route> routes(Method method, Class<?> clazz, String pathPrefix) {
        Set<Annotation> methodAnnotations = AnnotatedServiceFactory.httpMethodAnnotations(method);
        if (methodAnnotations.isEmpty()) {
            throw new IllegalArgumentException("HTTP Method specification is missing: " + method.getName());
        }
        Map<HttpMethod, List<String>> httpMethodPatternsMap = AnnotatedServiceFactory.getHttpMethodPatternsMap(method, methodAnnotations);
        String computedPathPrefix = AnnotatedServiceFactory.computePathPrefix(clazz, pathPrefix);
        Set<MediaType> consumableMediaTypes = AnnotatedServiceFactory.consumableMediaTypes(method, clazz);
        Set<MediaType> producibleMediaTypes = AnnotatedServiceFactory.producibleMediaTypes(method, clazz);
        return httpMethodPatternsMap.entrySet().stream().flatMap(pattern -> {
            HttpMethod httpMethod = (HttpMethod)((Object)((Object)pattern.getKey()));
            List pathMappings = (List)pattern.getValue();
            return pathMappings.stream().map(pathMapping -> Route.builder().path(computedPathPrefix, (String)pathMapping).methods(httpMethod).consumes(consumableMediaTypes).produces(producibleMediaTypes).matchesParams((Iterable<String>)AnnotatedServiceFactory.predicates(method, clazz, MatchesParam.class, MatchesParam::value)).matchesHeaders((Iterable<String>)AnnotatedServiceFactory.predicates(method, clazz, MatchesHeader.class, MatchesHeader::value)).build());
        }).collect(ImmutableList.toImmutableList());
    }

    private static HttpHeaders responseHeaders(Method method, Class<?> clazz, String classAlias, String methodAlias) {
        HttpHeadersBuilder defaultHeaders = HttpHeaders.builder();
        AnnotatedServiceFactory.setAdditionalHeader(defaultHeaders, clazz, "header", classAlias, "class", AdditionalHeader.class, AdditionalHeader::name, AdditionalHeader::value);
        AnnotatedServiceFactory.setAdditionalHeader(defaultHeaders, method, "header", methodAlias, "method", AdditionalHeader.class, AdditionalHeader::name, AdditionalHeader::value);
        return defaultHeaders.build();
    }

    private static HttpHeaders responseTrailers(Method method, Class<?> clazz, String classAlias, String methodAlias) {
        HttpHeadersBuilder defaultTrailers = HttpHeaders.builder();
        AnnotatedServiceFactory.setAdditionalHeader(defaultTrailers, clazz, "trailer", classAlias, "class", AdditionalTrailer.class, AdditionalTrailer::name, AdditionalTrailer::value);
        AnnotatedServiceFactory.setAdditionalHeader(defaultTrailers, method, "trailer", methodAlias, "method", AdditionalTrailer.class, AdditionalTrailer::name, AdditionalTrailer::value);
        return defaultTrailers.build();
    }

    private static boolean needToUseBlockingTaskExecutor(Object object, Method method, boolean useBlockingTaskExecutor) {
        return useBlockingTaskExecutor || AnnotationUtil.findFirst(method, Blocking.class) != null || AnnotationUtil.findFirst(object.getClass(), Blocking.class) != null;
    }

    private static List<AnnotatedValueResolver> getAnnotatedValueResolvers(List<RequestConverterFunction> req, Route route, Method method, Class<?> clazz, boolean useBlockingExecutor, DependencyInjector dependencyInjector, @Nullable String queryDelimiter) {
        List<Object> resolvers;
        Set<String> expectedParamNames = route.paramNames();
        try {
            resolvers = AnnotatedValueResolver.ofServiceMethod(method, expectedParamNames, AnnotatedValueResolver.toRequestObjectResolvers(req, method), useBlockingExecutor, dependencyInjector, queryDelimiter);
        }
        catch (AnnotatedValueResolver.NoParameterException ignored) {
            resolvers = ImmutableList.of();
        }
        Set requiredParamNames = resolvers.stream().filter(AnnotatedValueResolver::isPathVariable).map(AnnotatedValueResolver::httpElementName).collect(ImmutableSet.toImmutableSet());
        if (!expectedParamNames.containsAll(requiredParamNames)) {
            Sets.SetView missing = Sets.difference(requiredParamNames, expectedParamNames);
            throw new IllegalArgumentException("cannot find path variables: " + missing);
        }
        if (resolvers.stream().noneMatch(r -> r.annotationType() == RequestObject.class) && !requiredParamNames.containsAll(expectedParamNames)) {
            Sets.SetView<String> missing = Sets.difference(expectedParamNames, requiredParamNames);
            logger.warn("Some path variables of the method '" + method.getName() + "' of the class '" + clazz.getName() + "' do not have their corresponding parameters annotated with @Param. They would not be automatically injected: " + missing);
        }
        return resolvers;
    }

    private static List<Method> requestMappingMethods(Object object) {
        return ReflectionUtils.getAllMethods(object.getClass(), ReflectionUtils.withModifier(1)).stream().filter(m -> AnnotationUtil.getAnnotations((AnnotatedElement)m, AnnotationUtil.FindOption.LOOKUP_SUPER_CLASSES).stream().map(Annotation::annotationType).anyMatch(a -> a == Path.class || HTTP_METHOD_MAP.containsKey(a))).sorted(Comparator.comparingInt(AnnotatedServiceFactory::order)).collect(ImmutableList.toImmutableList());
    }

    private static int order(Method method) {
        Order order = AnnotationUtil.findFirst(method, Order.class);
        return order != null ? order.value() : 0;
    }

    private static Set<Annotation> httpMethodAnnotations(Method method) {
        return AnnotationUtil.getAnnotations((AnnotatedElement)method, AnnotationUtil.FindOption.LOOKUP_SUPER_CLASSES).stream().filter(annotation -> HTTP_METHOD_MAP.containsKey(annotation.annotationType())).collect(Collectors.toSet());
    }

    private static Set<MediaType> consumableMediaTypes(Method method, Class<?> clazz) {
        List<Consumes> consumes = AnnotationUtil.findAll(method, Consumes.class);
        if (consumes.isEmpty()) {
            consumes = AnnotationUtil.findAll(clazz, Consumes.class);
        }
        List types = consumes.stream().map(Consumes::value).map(MediaType::parse).collect(ImmutableList.toImmutableList());
        return AnnotatedServiceFactory.listToSet(types, Consumes.class);
    }

    private static Set<MediaType> producibleMediaTypes(Method method, Class<?> clazz) {
        List<Produces> produces = AnnotationUtil.findAll(method, Produces.class);
        if (produces.isEmpty()) {
            produces = AnnotationUtil.findAll(clazz, Produces.class);
        }
        List types = produces.stream().map(Produces::value).map(MediaType::parse).peek(type -> {
            if (type.hasWildcard()) {
                throw new IllegalArgumentException("Producible media types must not have a wildcard: " + type);
            }
        }).collect(ImmutableList.toImmutableList());
        return AnnotatedServiceFactory.listToSet(types, Produces.class);
    }

    private static <T extends Annotation> List<String> predicates(Method method, Class<?> clazz, Class<T> annotationType, Function<T, String> toStringPredicate) {
        List<T> classLevel = AnnotationUtil.findAll(clazz, annotationType);
        List<T> methodLevel = AnnotationUtil.findAll(method, annotationType);
        return Streams.concat(classLevel.stream(), methodLevel.stream()).map(toStringPredicate).collect(ImmutableList.toImmutableList());
    }

    private static Set<MediaType> listToSet(List<MediaType> types, Class<?> annotationClass) {
        LinkedHashSet<MediaType> set = new LinkedHashSet<MediaType>();
        for (MediaType type : types) {
            if (set.add(type)) continue;
            throw new IllegalArgumentException("Duplicated media type for @" + annotationClass.getSimpleName() + ": " + type);
        }
        return ImmutableSet.copyOf(set);
    }

    private static Map<HttpMethod, List<String>> getHttpMethodPatternsMap(Method method, Set<Annotation> methodAnnotations) {
        List pathPatterns = AnnotationUtil.findAll(method, Path.class).stream().map(Path::value).collect(ImmutableList.toImmutableList());
        boolean usePathPatterns = !pathPatterns.isEmpty();
        Map<HttpMethod, List<String>> httpMethodAnnotatedPatternMap = AnnotatedServiceFactory.getHttpMethodAnnotatedPatternMap(methodAnnotations);
        if (httpMethodAnnotatedPatternMap.isEmpty()) {
            throw new IllegalArgumentException(method.getDeclaringClass().getName() + '#' + method.getName() + " must have an HTTP method annotation.");
        }
        return httpMethodAnnotatedPatternMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            List httpMethodPaths = (List)entry.getValue();
            if (usePathPatterns && !httpMethodPaths.isEmpty()) {
                throw new IllegalArgumentException(method.getDeclaringClass().getName() + '#' + method.getName() + " cannot specify both an HTTP mapping and a Path mapping.");
            }
            if (usePathPatterns) {
                httpMethodPaths.addAll(pathPatterns);
            } else if (httpMethodPaths.isEmpty()) {
                httpMethodPaths.add("");
            }
            return ImmutableList.copyOf(httpMethodPaths);
        }));
    }

    private static Map<HttpMethod, List<String>> getHttpMethodAnnotatedPatternMap(Set<Annotation> methodAnnotations) {
        EnumMap<HttpMethod, List<String>> httpMethodPatternMap = new EnumMap<HttpMethod, List<String>>(HttpMethod.class);
        methodAnnotations.stream().filter(annotation -> HTTP_METHOD_MAP.containsKey(annotation.annotationType())).forEach(annotation -> {
            HttpMethod httpMethod = HTTP_METHOD_MAP.get(annotation.annotationType());
            String value = (String)AnnotatedObjectFactory.invokeValueMethod(annotation);
            List patterns = httpMethodPatternMap.computeIfAbsent(httpMethod, ignored -> new ArrayList());
            if (DefaultValues.isSpecified(value)) {
                patterns.add(value);
            }
        });
        return httpMethodPatternMap;
    }

    private static Function<? super HttpService, ? extends HttpService> decorator(Method method, Class<?> clazz, DependencyInjector dependencyInjector) {
        List<DecoratorAnnotationUtil.DecoratorAndOrder> decorators = DecoratorAnnotationUtil.collectDecorators(clazz, method);
        Function decorator = Function.identity();
        for (int i = decorators.size() - 1; i >= 0; --i) {
            DecoratorAnnotationUtil.DecoratorAndOrder d = decorators.get(i);
            decorator = decorator.andThen(d.decorator(dependencyInjector));
        }
        return decorator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DescriptionInfo findDescription(AnnotatedElement annotatedElement) {
        Objects.requireNonNull(annotatedElement, "annotatedElement");
        Description description = AnnotationUtil.findFirstDescription(annotatedElement);
        if (description != null) {
            String value = description.value();
            if (!DefaultValues.isSpecified(value)) return DescriptionInfo.empty();
            Preconditions.checkArgument(!value.isEmpty(), "value is empty.");
            return DescriptionInfo.from(description);
        }
        if (!(annotatedElement instanceof Parameter)) return DescriptionInfo.empty();
        Parameter parameter = (Parameter)annotatedElement;
        Executable executable = parameter.getDeclaringExecutable();
        Class<?> clazz = executable.getDeclaringClass();
        String fileName = ProcessedDocumentationHelper.getFileName(clazz.getCanonicalName());
        String propertyName = executable.getName() + '.' + parameter.getName();
        Properties cachedProperties = DOCUMENTATION_PROPERTIES_CACHE.getIfPresent(fileName);
        if (cachedProperties != null) {
            DescriptionInfo descriptionInfo;
            String propertyValue = cachedProperties.getProperty(propertyName);
            if (propertyValue != null) {
                descriptionInfo = DescriptionInfo.of(propertyValue);
                return descriptionInfo;
            }
            descriptionInfo = DescriptionInfo.empty();
            return descriptionInfo;
        }
        try (InputStream stream = AnnotatedServiceFactory.class.getClassLoader().getResourceAsStream(fileName);){
            if (stream == null) {
                DescriptionInfo descriptionInfo2 = DescriptionInfo.empty();
                return descriptionInfo2;
            }
            Properties properties = new Properties();
            properties.load(stream);
            DOCUMENTATION_PROPERTIES_CACHE.put(fileName, properties);
            String propertyValue = properties.getProperty(propertyName);
            DescriptionInfo descriptionInfo = propertyValue != null ? DescriptionInfo.of(propertyValue) : DescriptionInfo.empty();
            return descriptionInfo;
        }
        catch (IOException exception) {
            logger.warn("Failed to load an API description file: {}", (Object)fileName, (Object)exception);
        }
        return DescriptionInfo.empty();
    }

    private static String computePathPrefix(Class<?> clazz, String pathPrefix) {
        RouteUtil.ensureAbsolutePath(pathPrefix, "pathPrefix");
        PathPrefix pathPrefixAnnotation = AnnotationUtil.findFirst(clazz, PathPrefix.class);
        if (pathPrefixAnnotation == null) {
            return pathPrefix;
        }
        String pathPrefixFromAnnotation = pathPrefixAnnotation.value();
        RouteUtil.ensureAbsolutePath(pathPrefixFromAnnotation, "pathPrefixFromAnnotation");
        return ArmeriaHttpUtil.concatPaths(pathPrefix, pathPrefixFromAnnotation);
    }

    private AnnotatedServiceFactory() {
    }

    private static /* synthetic */ AnnotatedServiceElement lambda$create$1(List req, Method method, Class clazz, boolean needToUseBlockingTaskExecutor, DependencyInjector dependencyInjector, String queryDelimiter, Object object, int overloadId, List eh, List res, HttpStatus defaultStatus, HttpHeaders responseHeaders, HttpHeaders responseTrailers, Route route) {
        List<AnnotatedValueResolver> resolvers = AnnotatedServiceFactory.getAnnotatedValueResolvers(req, route, method, clazz, needToUseBlockingTaskExecutor, dependencyInjector, queryDelimiter);
        return new AnnotatedServiceElement(route, new DefaultAnnotatedService(object, method, overloadId, resolvers, eh, res, route, defaultStatus, responseHeaders, responseTrailers, needToUseBlockingTaskExecutor), AnnotatedServiceFactory.decorator(method, clazz, dependencyInjector));
    }
}

