/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.ObjectCollectingUtil;
import karate.com.linecorp.armeria.internal.server.annotation.ScalaUtil;
import karate.org.reactivestreams.Publisher;

public final class ClassUtil {
    private static final String CGLIB_CLASS_SEPARATOR = "$$";

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return clazz;
    }

    @Nullable
    public static Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static Type unwrapUnaryAsyncType(Type type) {
        return ClassUtil.unwrapAsyncType(type, ClassUtil::isUnaryAsyncType);
    }

    public static Type unwrapAsyncType(Type type) {
        return ClassUtil.unwrapAsyncType(type, ClassUtil::isAsyncType);
    }

    private static Type unwrapAsyncType(Type type, Predicate<Class<?>> asyncTypePredicate) {
        if (type instanceof Class) {
            return type;
        }
        if (!(type instanceof ParameterizedType)) {
            return type;
        }
        ParameterizedType ptype = (ParameterizedType)type;
        Type[] typeArguments = ptype.getActualTypeArguments();
        if (typeArguments.length == 0) {
            return type;
        }
        Class clazz = (Class)ptype.getRawType();
        Type typeArgument = typeArguments[0];
        return asyncTypePredicate.test(clazz) ? typeArgument : type;
    }

    private static boolean isUnaryAsyncType(Class<?> clazz) {
        return CompletionStage.class.isAssignableFrom(clazz) || ScalaUtil.isScalaFuture(clazz) || ObjectCollectingUtil.MONO_CLASS != null && ObjectCollectingUtil.MONO_CLASS.isAssignableFrom(clazz);
    }

    private static boolean isAsyncType(Class<?> clazz) {
        return CompletionStage.class.isAssignableFrom(clazz) || Publisher.class.isAssignableFrom(clazz) || ScalaUtil.isScalaFuture(clazz);
    }

    private ClassUtil() {
    }
}

