/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.DependencyInjector;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotatedObjectFactory;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import karate.com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import karate.com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.annotation.Decorator;
import karate.com.linecorp.armeria.server.annotation.DecoratorFactory;
import karate.com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import karate.com.linecorp.armeria.server.annotation.Decorators;

public final class DecoratorAnnotationUtil {
    public static List<DecoratorAndOrder> collectDecorators(Class<?> clazz, Method method) {
        ArrayList<DecoratorAndOrder> decorators = new ArrayList<DecoratorAndOrder>();
        DecoratorAnnotationUtil.collectDecorators(decorators, AnnotationUtil.getAllAnnotations(clazz));
        DecoratorAnnotationUtil.collectDecorators(decorators, AnnotationUtil.getAllAnnotations(method));
        decorators.sort(Comparator.comparing(DecoratorAndOrder::order));
        return decorators;
    }

    private static void collectDecorators(List<DecoratorAndOrder> list, List<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof Decorator) {
                Decorator d = (Decorator)annotation;
                list.add(new DecoratorAndOrder(d, d, null, d.order()));
                continue;
            }
            if (annotation instanceof Decorators) {
                Decorator[] decorators;
                for (Decorator d : decorators = ((Decorators)annotation).value()) {
                    list.add(new DecoratorAndOrder(d, d, null, d.order()));
                }
                continue;
            }
            DecoratorAndOrder udd = DecoratorAnnotationUtil.userDefinedDecorator(annotation);
            if (udd != null) {
                list.add(udd);
                continue;
            }
            try {
                Annotation decorator;
                Annotation[] decorators;
                Method method = Iterables.getFirst(ReflectionUtils.getMethods(annotation.annotationType(), ReflectionUtils.withName("value")), null);
                if (method == null) continue;
                Annotation[] annotationArray = decorators = (Annotation[])method.invoke((Object)annotation, new Object[0]);
                int n = annotationArray.length;
                for (int i = 0; i < n && (udd = DecoratorAnnotationUtil.userDefinedDecorator(decorator = annotationArray[i])) != null; ++i) {
                    list.add(udd);
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Nullable
    private static DecoratorAndOrder userDefinedDecorator(Annotation annotation) {
        DecoratorFactory df = AnnotationUtil.findFirstDeclared(annotation.annotationType(), DecoratorFactory.class);
        if (df == null) {
            return null;
        }
        int order = 0;
        try {
            Object value;
            Method method = Iterables.getFirst(ReflectionUtils.getMethods(annotation.annotationType(), ReflectionUtils.withName("order")), null);
            if (method != null && (value = method.invoke((Object)annotation, new Object[0])) instanceof Integer) {
                order = (Integer)value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new DecoratorAndOrder(annotation, null, df, order);
    }

    private DecoratorAnnotationUtil() {
    }

    public static final class DecoratorAndOrder {
        private final Annotation annotation;
        @Nullable
        private final Decorator decoratorAnnotation;
        @Nullable
        private final DecoratorFactory decoratorFactory;
        private final int order;

        private DecoratorAndOrder(Annotation annotation, @Nullable Decorator decoratorAnnotation, @Nullable DecoratorFactory decoratorFactory, int order) {
            this.annotation = annotation;
            this.decoratorAnnotation = decoratorAnnotation;
            this.decoratorFactory = decoratorFactory;
            this.order = order;
        }

        public Annotation annotation() {
            return this.annotation;
        }

        @Nullable
        public Decorator decoratorAnnotation() {
            return this.decoratorAnnotation;
        }

        @Nullable
        public DecoratorFactory decoratorFactory() {
            return this.decoratorFactory;
        }

        public Function<? super HttpService, ? extends HttpService> decorator(DependencyInjector dependencyInjector) {
            if (this.decoratorFactory != null) {
                DecoratorFactoryFunction factory = AnnotatedObjectFactory.getInstance(this.decoratorFactory, DecoratorFactoryFunction.class, dependencyInjector);
                return factory.newDecorator(this.annotation);
            }
            assert (this.decoratorAnnotation != null);
            return service -> service.decorate(AnnotatedObjectFactory.getInstance(this.decoratorAnnotation, DecoratingHttpServiceFunction.class, dependencyInjector));
        }

        public int order() {
            return this.order;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("annotation", this.annotation).add("decoratorAnnotation", this.decoratorAnnotation).add("decoratorFactory", this.decoratorFactory).add("order", this.order).toString();
        }
    }
}

