/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotatedDocServicePlugin;
import karate.com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import karate.com.linecorp.armeria.internal.server.annotation.DefaultDescriptiveTypeInfoProvider;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.annotation.Description;
import karate.com.linecorp.armeria.server.docs.ContainerTypeSignature;
import karate.com.linecorp.armeria.server.docs.DescriptionInfo;
import karate.com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import karate.com.linecorp.armeria.server.docs.DescriptiveTypeInfoProvider;
import karate.com.linecorp.armeria.server.docs.FieldInfo;
import karate.com.linecorp.armeria.server.docs.FieldRequirement;
import karate.com.linecorp.armeria.server.docs.StructInfo;
import karate.com.linecorp.armeria.server.docs.TypeSignature;
import karate.com.linecorp.armeria.server.docs.TypeSignatureType;

enum ReflectiveDescriptiveTypeInfoProvider implements DescriptiveTypeInfoProvider
{
    INSTANCE;


    @Override
    @Nonnull
    public DescriptiveTypeInfo newDescriptiveTypeInfo(Object typeDescriptor) {
        Class clazz = (Class)typeDescriptor;
        List fieldInfos = Arrays.stream(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(ReflectiveDescriptiveTypeInfoProvider::fieldInfo).collect(ImmutableList.toImmutableList());
        DescriptionInfo descriptionInfo = ReflectiveDescriptiveTypeInfoProvider.descriptionInfo(clazz);
        return new StructInfo(clazz.getName(), fieldInfos, descriptionInfo);
    }

    private static FieldInfo fieldInfo(Field field) {
        FieldRequirement fieldRequirement;
        Type type = field.getGenericType();
        TypeSignature typeSignature = AnnotatedDocServicePlugin.toTypeSignature(type);
        DescriptionInfo descriptionInfo = ReflectiveDescriptiveTypeInfoProvider.descriptionInfo(field);
        if (typeSignature.type() == TypeSignatureType.OPTIONAL) {
            typeSignature = ((ContainerTypeSignature)typeSignature).typeParameters().get(0);
            fieldRequirement = FieldRequirement.OPTIONAL;
        } else {
            fieldRequirement = DefaultDescriptiveTypeInfoProvider.isNullable(field) ? FieldRequirement.OPTIONAL : FieldRequirement.REQUIRED;
        }
        return FieldInfo.builder(field.getName(), typeSignature).requirement(fieldRequirement).descriptionInfo(descriptionInfo).build();
    }

    private static DescriptionInfo descriptionInfo(AnnotatedElement element) {
        Description description = AnnotationUtil.findFirst(element, Description.class);
        if (description == null) {
            return DescriptionInfo.empty();
        }
        return DescriptionInfo.from(description);
    }
}

