/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server.annotation;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.util.Failure;

final class ScalaUtil {
    @Nullable
    private static final Class<?> SCALA_FUTURE;
    @Nullable
    private static final Class<?> SCALA_EXECUTION_CONTEXT;

    static boolean isScalaFuture(Class<?> clazz) {
        return SCALA_FUTURE != null && SCALA_FUTURE.isAssignableFrom(clazz);
    }

    static boolean isExecutionContext(Class<?> clazz) {
        return SCALA_EXECUTION_CONTEXT != null && SCALA_EXECUTION_CONTEXT.isAssignableFrom(clazz);
    }

    private ScalaUtil() {
    }

    static {
        Class<?> executionContextClass;
        Class<?> futureClass;
        try {
            futureClass = Class.forName("scala.concurrent.Future");
        }
        catch (ClassNotFoundException e) {
            futureClass = null;
        }
        SCALA_FUTURE = futureClass;
        try {
            executionContextClass = Class.forName("scala.concurrent.ExecutionContext");
        }
        catch (ClassNotFoundException e) {
            executionContextClass = null;
        }
        SCALA_EXECUTION_CONTEXT = executionContextClass;
    }

    static final class FutureConverter {
        static <T> CompletableFuture<T> toCompletableFuture(Future<T> scalaFuture, ExecutorService executor) {
            CompletableFuture completableFuture = new CompletableFuture();
            scalaFuture.onComplete(value -> {
                if (value.isSuccess()) {
                    completableFuture.complete(value.get());
                } else {
                    Failure failure = (Failure)value;
                    completableFuture.completeExceptionally(failure.exception());
                }
                return null;
            }, (ExecutionContext)ExecutionContext.fromExecutorService((ExecutorService)executor));
            return completableFuture;
        }

        private FutureConverter() {
        }
    }
}

