/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import java.io.IOException;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1TaggedObject;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERApplicationSpecific;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DLApplicationSpecific;

public abstract class ASN1ApplicationSpecific
extends ASN1Primitive
implements ASN1ApplicationSpecificParser {
    final ASN1TaggedObject taggedObject;

    ASN1ApplicationSpecific(ASN1TaggedObject aSN1TaggedObject) {
        ASN1ApplicationSpecific.checkTagClass(aSN1TaggedObject.getTagClass());
        this.taggedObject = aSN1TaggedObject;
    }

    public final ASN1Primitive getLoadedObject() {
        return this;
    }

    public ASN1TaggedObject getTaggedObject() {
        return this.taggedObject;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        ASN1TaggedObject aSN1TaggedObject;
        if (aSN1Primitive instanceof ASN1ApplicationSpecific) {
            aSN1TaggedObject = ((ASN1ApplicationSpecific)aSN1Primitive).taggedObject;
        } else if (aSN1Primitive instanceof ASN1TaggedObject) {
            aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
        } else {
            return false;
        }
        return this.taggedObject.equals(aSN1TaggedObject);
    }

    public int hashCode() {
        return this.taggedObject.hashCode();
    }

    boolean encodeConstructed() {
        return this.taggedObject.encodeConstructed();
    }

    int encodedLength(boolean bl) throws IOException {
        return this.taggedObject.encodedLength(bl);
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        this.taggedObject.encode(aSN1OutputStream, bl);
    }

    ASN1Primitive toDERObject() {
        return new DERApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDERObject());
    }

    ASN1Primitive toDLObject() {
        return new DLApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDLObject());
    }

    private static int checkTagClass(int n) {
        if (64 != n) {
            throw new IllegalArgumentException();
        }
        return n;
    }
}

