/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import java.io.IOException;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1String;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1UniversalType;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERGeneralString;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Strings;

public abstract class ASN1GeneralString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1GeneralString.class, 27){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1GeneralString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    ASN1GeneralString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 27, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralString)) {
            return false;
        }
        ASN1GeneralString aSN1GeneralString = (ASN1GeneralString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1GeneralString.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1GeneralString createPrimitive(byte[] byArray) {
        return new DERGeneralString(byArray, false);
    }
}

