/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import java.io.IOException;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1String;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1UniversalType;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERUTF8String;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Strings;

public abstract class ASN1UTF8String
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1UTF8String.class, 12){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1UTF8String.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    ASN1UTF8String(String string) {
        this(Strings.toUTF8ByteArray(string), false);
    }

    ASN1UTF8String(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public final String getString() {
        return Strings.fromUTF8ByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UTF8String)) {
            return false;
        }
        ASN1UTF8String aSN1UTF8String = (ASN1UTF8String)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1UTF8String.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 12, this.contents);
    }

    static ASN1UTF8String createPrimitive(byte[] byArray) {
        return new DERUTF8String(byArray, false);
    }
}

