/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509;

import java.math.BigInteger;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Integer;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Object;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.BigIntegers;

public class CRLNumber
extends ASN1Object {
    private BigInteger number;

    public CRLNumber(BigInteger bigInteger) {
        if (BigIntegers.ZERO.compareTo(bigInteger) > 0) {
            throw new IllegalArgumentException("Invalid CRL number : not in (0..MAX)");
        }
        this.number = bigInteger;
    }

    public BigInteger getCRLNumber() {
        return this.number;
    }

    public String toString() {
        return "CRLNumber: " + this.getCRLNumber();
    }

    public ASN1Primitive toASN1Primitive() {
        return new ASN1Integer(this.number);
    }
}

