/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.cert;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Encodable;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1EncodableVector;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Integer;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Object;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERBitString;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.Certificate;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.ExtensionsGenerator;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.TBSCertificate;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.Time;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.cert.CertIOException;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.cert.X509CertificateHolder;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.ContentSigner;

public class X509v3CertificateBuilder {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private ExtensionsGenerator extGenerator;

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(x500Name, bigInteger, new Time(date), new Time(date2), x500Name2, subjectPublicKeyInfo);
    }

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Time time, Time time2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.tbsGen.setSerialNumber(new ASN1Integer(bigInteger));
        this.tbsGen.setIssuer(x500Name);
        this.tbsGen.setStartDate(time);
        this.tbsGen.setEndDate(time2);
        this.tbsGen.setSubject(x500Name2);
        this.tbsGen.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.extGenerator = new ExtensionsGenerator();
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) throws CertIOException {
        try {
            this.extGenerator.addExtension(aSN1ObjectIdentifier, bl, aSN1Encodable);
        }
        catch (IOException iOException) {
            throw new CertIOException("cannot encode extension: " + iOException.getMessage(), iOException);
        }
        return this;
    }

    public X509CertificateHolder build(ContentSigner contentSigner) {
        this.tbsGen.setSignature(contentSigner.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        try {
            TBSCertificate tBSCertificate = this.tbsGen.generateTBSCertificate();
            return new X509CertificateHolder(X509v3CertificateBuilder.generateStructure(tBSCertificate, contentSigner.getAlgorithmIdentifier(), X509v3CertificateBuilder.generateSig(contentSigner, tBSCertificate)));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot produce certificate signature");
        }
    }

    private static byte[] generateSig(ContentSigner contentSigner, ASN1Object aSN1Object) throws IOException {
        OutputStream outputStream = contentSigner.getOutputStream();
        aSN1Object.encodeTo(outputStream, "DER");
        outputStream.close();
        return contentSigner.getSignature();
    }

    private static Certificate generateStructure(TBSCertificate tBSCertificate, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(tBSCertificate);
        aSN1EncodableVector.add(algorithmIdentifier);
        aSN1EncodableVector.add(new DERBitString(byArray));
        return Certificate.getInstance(new DERSequence(aSN1EncodableVector));
    }
}

