/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.KeyGenerationParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.DSAParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.DSAPublicKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.WNafUtil;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.BigIntegers;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DSAKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dSAParameters = this.param.getParameters();
        BigInteger bigInteger = DSAKeyPairGenerator.generatePrivateKey(dSAParameters.getQ(), this.param.getRandom());
        BigInteger bigInteger2 = DSAKeyPairGenerator.calculatePublicKey(dSAParameters.getP(), dSAParameters.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(bigInteger2, dSAParameters), new DSAPrivateKeyParameters(bigInteger, dSAParameters));
    }

    private static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        int n = bigInteger.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(bigInteger2 = BigIntegers.createRandomInRange(ONE, bigInteger.subtract(ONE), secureRandom)) < n) {
        }
        return bigInteger2;
    }

    private static BigInteger calculatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }
}

