/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.KeyGenerationParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECDomainParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECKeyGenerationParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECPrivateKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECPublicKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECConstants;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECMultiplier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.FixedPointCombMultiplier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.WNafUtil;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.BigIntegers;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

