/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1EncodableVector;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Sequence;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERBitString;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.CompositePrivateKey;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.io.OutputStreamFactory;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.ContentSigner;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.OperatorCreationException;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.RuntimeOperatorException;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.operator.jcajce.OperatorHelper;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.io.TeeOutputStream;

public class JcaContentSignerBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private String signatureAlgorithm;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmParameterSpec sigAlgSpec;

    public JcaContentSignerBuilder(String string) {
        this.signatureAlgorithm = string;
        this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(string);
        this.sigAlgSpec = null;
    }

    public ContentSigner build(PrivateKey privateKey) throws OperatorCreationException {
        if (privateKey instanceof CompositePrivateKey) {
            return this.buildComposite((CompositePrivateKey)privateKey);
        }
        try {
            final Signature signature = this.helper.createSignature(this.sigAlgId);
            final AlgorithmIdentifier algorithmIdentifier = this.sigAlgId;
            if (this.random != null) {
                signature.initSign(privateKey, this.random);
            } else {
                signature.initSign(privateKey);
            }
            return new ContentSigner(){
                private OutputStream stream;
                {
                    this.stream = OutputStreamFactory.createStream(signature);
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return algorithmIdentifier;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        return signature.sign();
                    }
                    catch (SignatureException signatureException) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create signer: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private ContentSigner buildComposite(CompositePrivateKey compositePrivateKey) throws OperatorCreationException {
        try {
            List<PrivateKey> list = compositePrivateKey.getPrivateKeys();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(this.sigAlgId.getParameters());
            final Signature[] signatureArray = new Signature[aSN1Sequence.size()];
            for (int i = 0; i != aSN1Sequence.size(); ++i) {
                signatureArray[i] = this.helper.createSignature(AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(i)));
                if (this.random != null) {
                    signatureArray[i].initSign(list.get(i), this.random);
                    continue;
                }
                signatureArray[i].initSign(list.get(i));
            }
            OutputStream outputStream = OutputStreamFactory.createStream(signatureArray[0]);
            for (int i = 1; i != signatureArray.length; ++i) {
                outputStream = new TeeOutputStream(outputStream, OutputStreamFactory.createStream(signatureArray[i]));
            }
            final OutputStream outputStream2 = outputStream;
            return new ContentSigner(){
                OutputStream stream;
                {
                    this.stream = outputStream2;
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return JcaContentSignerBuilder.this.sigAlgId;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                        for (int i = 0; i != signatureArray.length; ++i) {
                            aSN1EncodableVector.add(new DERBitString(signatureArray[i].sign()));
                        }
                        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
                    }
                    catch (IOException iOException) {
                        throw new RuntimeOperatorException("exception encoding signature: " + iOException.getMessage(), iOException);
                    }
                    catch (SignatureException signatureException) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create signer: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

