/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.Composer;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSSignature;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSSPrivateKeyParameters
extends LMSKeyParameters {
    private final int l;
    private final boolean isShard;
    private List<LMSPrivateKeyParameters> keys;
    private List<LMSSignature> sig;
    private final long indexLimit;
    private long index = 0L;
    private HSSPublicKeyParameters publicKey;

    private HSSPrivateKeyParameters(int n, List<LMSPrivateKeyParameters> list, List<LMSSignature> list2, long l, long l2, boolean bl) {
        super(true);
        this.l = n;
        this.keys = Collections.unmodifiableList(list);
        this.sig = Collections.unmodifiableList(list2);
        this.index = l;
        this.indexLimit = l2;
        this.isShard = bl;
    }

    public static HSSPrivateKeyParameters getInstance(byte[] byArray, byte[] byArray2) throws IOException {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(byArray);
        hSSPrivateKeyParameters.publicKey = HSSPublicKeyParameters.getInstance(byArray2);
        return hSSPrivateKeyParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSPrivateKeyParameters getInstance(Object object) throws IOException {
        if (object instanceof HSSPrivateKeyParameters) {
            return (HSSPrivateKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            int n;
            if (((DataInputStream)object).readInt() != 0) {
                throw new IllegalStateException("unknown version for hss private key");
            }
            int n2 = ((DataInputStream)object).readInt();
            long l = ((DataInputStream)object).readLong();
            long l2 = ((DataInputStream)object).readLong();
            boolean bl = ((DataInputStream)object).readBoolean();
            ArrayList<LMSPrivateKeyParameters> arrayList = new ArrayList<LMSPrivateKeyParameters>();
            ArrayList<LMSSignature> arrayList2 = new ArrayList<LMSSignature>();
            for (n = 0; n < n2; ++n) {
                arrayList.add(LMSPrivateKeyParameters.getInstance(object));
            }
            for (n = 0; n < n2 - 1; ++n) {
                arrayList2.add(LMSSignature.getInstance(object));
            }
            return new HSSPrivateKeyParameters(n2, arrayList, arrayList2, l, l2, bl);
        }
        if (object instanceof byte[]) {
            InputStream inputStream = null;
            try {
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                HSSPrivateKeyParameters hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(inputStream);
                return hSSPrivateKeyParameters;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        if (object instanceof InputStream) {
            return HSSPrivateKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public int getL() {
        return this.l;
    }

    private static HSSPrivateKeyParameters makeCopy(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        try {
            return HSSPrivateKeyParameters.getInstance(hSSPrivateKeyParameters.getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    LMSPrivateKeyParameters getRootKey() {
        return this.keys.get(0);
    }

    public synchronized HSSPublicKeyParameters getPublicKey() {
        return new HSSPublicKeyParameters(this.l, this.getRootKey().getPublicKey());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HSSPrivateKeyParameters hSSPrivateKeyParameters = (HSSPrivateKeyParameters)object;
        if (this.l != hSSPrivateKeyParameters.l) {
            return false;
        }
        if (this.isShard != hSSPrivateKeyParameters.isShard) {
            return false;
        }
        if (this.indexLimit != hSSPrivateKeyParameters.indexLimit) {
            return false;
        }
        if (this.index != hSSPrivateKeyParameters.index) {
            return false;
        }
        if (!this.keys.equals(hSSPrivateKeyParameters.keys)) {
            return false;
        }
        return this.sig.equals(hSSPrivateKeyParameters.sig);
    }

    @Override
    public synchronized byte[] getEncoded() throws IOException {
        Composer composer = Composer.compose().u32str(0).u32str(this.l).u64str(this.index).u64str(this.indexLimit).bool(this.isShard);
        for (LMSPrivateKeyParameters encodable : this.keys) {
            composer.bytes(encodable);
        }
        for (LMSSignature lMSSignature : this.sig) {
            composer.bytes(lMSSignature);
        }
        return composer.build();
    }

    public int hashCode() {
        int n = this.l;
        n = 31 * n + (this.isShard ? 1 : 0);
        n = 31 * n + this.keys.hashCode();
        n = 31 * n + this.sig.hashCode();
        n = 31 * n + (int)(this.indexLimit ^ this.indexLimit >>> 32);
        n = 31 * n + (int)(this.index ^ this.index >>> 32);
        return n;
    }

    protected Object clone() throws CloneNotSupportedException {
        return HSSPrivateKeyParameters.makeCopy(this);
    }
}

