/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.rainbow;

import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;

public class Layer {
    private int vi;
    private int viNext;
    private int oi;
    private short[][][] coeff_alpha;
    private short[][][] coeff_beta;
    private short[][] coeff_gamma;
    private short[] coeff_eta;

    public Layer(byte by, byte by2, short[][][] sArray, short[][][] sArray2, short[][] sArray3, short[] sArray4) {
        this.vi = by & 0xFF;
        this.viNext = by2 & 0xFF;
        this.oi = this.viNext - this.vi;
        this.coeff_alpha = sArray;
        this.coeff_beta = sArray2;
        this.coeff_gamma = sArray3;
        this.coeff_eta = sArray4;
    }

    public int getVi() {
        return this.vi;
    }

    public int getViNext() {
        return this.viNext;
    }

    public int getOi() {
        return this.oi;
    }

    public short[][][] getCoeffAlpha() {
        return this.coeff_alpha;
    }

    public short[][][] getCoeffBeta() {
        return this.coeff_beta;
    }

    public short[][] getCoeffGamma() {
        return this.coeff_gamma;
    }

    public short[] getCoeffEta() {
        return this.coeff_eta;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Layer)) {
            return false;
        }
        Layer layer = (Layer)object;
        return this.vi == layer.getVi() && this.viNext == layer.getViNext() && this.oi == layer.getOi() && RainbowUtil.equals(this.coeff_alpha, layer.getCoeffAlpha()) && RainbowUtil.equals(this.coeff_beta, layer.getCoeffBeta()) && RainbowUtil.equals(this.coeff_gamma, layer.getCoeffGamma()) && RainbowUtil.equals(this.coeff_eta, layer.getCoeffEta());
    }

    public int hashCode() {
        int n = this.vi;
        n = n * 37 + this.viNext;
        n = n * 37 + this.oi;
        n = n * 37 + Arrays.hashCode(this.coeff_alpha);
        n = n * 37 + Arrays.hashCode(this.coeff_beta);
        n = n * 37 + Arrays.hashCode(this.coeff_gamma);
        n = n * 37 + Arrays.hashCode(this.coeff_eta);
        return n;
    }
}

