/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.newhope;

import java.io.IOException;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;

public class BCNHPrivateKey
implements NHPrivateKey {
    private transient NHPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCNHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (NHPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey bCNHPrivateKey = (BCNHPrivateKey)object;
        return Arrays.areEqual(this.params.getSecData(), bCNHPrivateKey.params.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getSecData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }
}

