/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.sphincs;

import java.io.IOException;
import java.security.PublicKey;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;

public class BCSphincs256PublicKey
implements SPHINCSKey,
PublicKey {
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPublicKeyParameters params;

    public BCSphincs256PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.treeDigest = SPHINCS256KeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PublicKey) {
            BCSphincs256PublicKey bCSphincs256PublicKey = (BCSphincs256PublicKey)object;
            return this.treeDigest.equals(bCSphincs256PublicKey.treeDigest) && Arrays.areEqual(this.params.getKeyData(), bCSphincs256PublicKey.params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            if (this.params.getTreeDigest() != null) {
                subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, this.params.getKeyData());
            }
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }
}

