/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra;

import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.IntUtils;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.pqc.math.linearalgebra.Matrix;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] byArray) {
        if (byArray.length < 9) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.numRows = LittleEndianConversions.OS2IP(byArray, 0);
        this.numColumns = LittleEndianConversions.OS2IP(byArray, 4);
        int n = (this.numColumns + 7 >>> 3) * this.numRows;
        if (this.numRows <= 0 || n != byArray.length - 8) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.length = this.numColumns + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n2 = this.numColumns >> 5;
        int n3 = this.numColumns & 0x1F;
        int n4 = 8;
        for (int i = 0; i < this.numRows; ++i) {
            int n5 = 0;
            while (n5 < n2) {
                this.matrix[i][n5] = LittleEndianConversions.OS2IP(byArray, n4);
                ++n5;
                n4 += 4;
            }
            for (n5 = 0; n5 < n3; n5 += 8) {
                int[] nArray = this.matrix[i];
                int n6 = n2;
                nArray[n6] = nArray[n6] ^ (byArray[n4++] & 0xFF) << n5;
            }
        }
    }

    public GF2Matrix(int n, int[][] nArray) {
        if (nArray[0].length != n + 31 >> 5) {
            throw new ArithmeticException("Int array does not match given number of columns.");
        }
        this.numColumns = n;
        this.numRows = nArray.length;
        this.length = nArray[0].length;
        int n2 = n & 0x1F;
        int n3 = n2 == 0 ? -1 : (1 << n2) - 1;
        for (int i = 0; i < this.numRows; ++i) {
            int[] nArray2 = nArray[i];
            int n4 = this.length - 1;
            nArray2[n4] = nArray2[n4] & n3;
        }
        this.matrix = nArray;
    }

    public GF2Matrix(GF2Matrix gF2Matrix) {
        this.numColumns = gF2Matrix.getNumColumns();
        this.numRows = gF2Matrix.getNumRows();
        this.length = gF2Matrix.length;
        this.matrix = new int[gF2Matrix.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = IntUtils.clone(gF2Matrix.matrix[i]);
        }
    }

    public byte[] getEncoded() {
        int n = this.numColumns + 7 >>> 3;
        n *= this.numRows;
        byte[] byArray = new byte[n += 8];
        LittleEndianConversions.I2OSP(this.numRows, byArray, 0);
        LittleEndianConversions.I2OSP(this.numColumns, byArray, 4);
        int n2 = this.numColumns >>> 5;
        int n3 = this.numColumns & 0x1F;
        int n4 = 8;
        for (int i = 0; i < this.numRows; ++i) {
            int n5 = 0;
            while (n5 < n2) {
                LittleEndianConversions.I2OSP(this.matrix[i][n5], byArray, n4);
                ++n5;
                n4 += 4;
            }
            for (n5 = 0; n5 < n3; n5 += 8) {
                byArray[n4++] = (byte)(this.matrix[i][n2] >>> n5 & 0xFF);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2Matrix)) {
            return false;
        }
        GF2Matrix gF2Matrix = (GF2Matrix)object;
        if (this.numRows != gF2Matrix.numRows || this.numColumns != gF2Matrix.numColumns || this.length != gF2Matrix.length) {
            return false;
        }
        for (int i = 0; i < this.numRows; ++i) {
            if (IntUtils.equals(this.matrix[i], gF2Matrix.matrix[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        for (int i = 0; i < this.numRows; ++i) {
            n = n * 31 + Arrays.hashCode(this.matrix[i]);
        }
        return n;
    }

    public String toString() {
        int n = this.numColumns & 0x1F;
        int n2 = n == 0 ? this.length : this.length - 1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numRows; ++i) {
            int n3;
            int n4;
            int n5;
            stringBuffer.append(i + ": ");
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = this.matrix[i][n5];
                for (n3 = 0; n3 < 32; ++n3) {
                    int n6 = n4 >>> n3 & 1;
                    if (n6 == 0) {
                        stringBuffer.append('0');
                        continue;
                    }
                    stringBuffer.append('1');
                }
                stringBuffer.append(' ');
            }
            n5 = this.matrix[i][this.length - 1];
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n5 >>> n4 & 1;
                if (n3 == 0) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append('1');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

