/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.fastutil;

public class Arrays {
    private Arrays() {
    }

    public static void ensureFromTo(int arrayLength, int from, int to) {
        assert (arrayLength >= 0);
        if (from < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than array length (" + arrayLength + ")");
        }
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        assert (arrayLength >= 0);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (length > arrayLength - offset) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + ((long)offset + (long)length) + ") is greater than array length (" + arrayLength + ")");
        }
    }
}

