/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.fastutil.bytes;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.Size64;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.AbstractByteList;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteArrays;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteCollection;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteComparator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteComparators;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteListIterator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteSpliterator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteSpliterators;
import karate.com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteUnaryOperator;

public interface ByteList
extends ByteCollection,
Comparable<List<? extends Byte>>,
List<Byte> {
    @Override
    public ByteListIterator iterator();

    @Override
    default public ByteSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractByteList.IndexBasedSpliterator(this, 0);
        }
        return ByteSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public ByteListIterator listIterator();

    public ByteListIterator listIterator(int var1);

    public ByteList subList(int var1, int var2);

    public void getElements(int var1, byte[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(byte[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index, byte[] a) {
        this.setElements(index, a, 0, a.length);
    }

    default public void setElements(int index, byte[] a, int offset, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        ByteArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        ByteListIterator iter2 = this.listIterator(index);
        int i = 0;
        while (i < length) {
            iter2.nextByte();
            iter2.set(a[offset + i++]);
        }
    }

    @Override
    public boolean add(byte var1);

    @Override
    public void add(int var1, byte var2);

    @Override
    @Deprecated
    default public void add(int index, Byte key) {
        this.add(index, (byte)key);
    }

    @Override
    public byte set(int var1, byte var2);

    default public void replaceAll(ByteUnaryOperator operator) {
        ByteListIterator iter2 = this.listIterator();
        while (iter2.hasNext()) {
            iter2.set(operator.apply(iter2.nextByte()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Byte> operator) {
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof ByteUnaryOperator ? (ByteUnaryOperator)operator : operator::apply);
    }

    public byte getByte(int var1);

    public int indexOf(byte var1);

    public int lastIndexOf(byte var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return ByteCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Byte get(int index) {
        return this.getByte(index);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Byte)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Byte)o);
    }

    @Override
    @Deprecated
    default public boolean add(Byte k) {
        return this.add((byte)k);
    }

    public byte removeByte(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return ByteCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Byte remove(int index) {
        return this.removeByte(index);
    }

    @Override
    @Deprecated
    default public Byte set(int index, Byte k) {
        return this.set(index, (byte)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Byte> comparator) {
        this.sort(ByteComparators.asByteComparator(comparator));
    }

    default public void sort(ByteComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            byte[] elements = this.toByteArray();
            ByteArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(ByteComparator comparator) {
        byte[] elements = this.toByteArray();
        if (comparator == null) {
            ByteArrays.unstableSort(elements);
        } else {
            ByteArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

