/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.fastutil.chars;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import karate.com.linecorp.armeria.internal.shaded.fastutil.Arrays;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.AbstractCharList;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharArrays;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharCollection;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharComparator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharConsumer;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharIterator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharIterators;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharList;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharListIterator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharPredicate;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharSpliterator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.chars.CharSpliterators;

public class CharArrayList
extends AbstractCharList
implements Serializable,
Cloneable,
RandomAccess {
    protected transient char[] a;
    protected int size;

    private static final char[] copyArraySafe(char[] a, int length) {
        if (length == 0) {
            return CharArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(a, length);
    }

    protected CharArrayList(char[] a, boolean wrapped) {
        this.a = a;
    }

    private void initArrayFromCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0 ? CharArrays.EMPTY_ARRAY : new char[capacity];
    }

    public CharArrayList(int capacity) {
        this.initArrayFromCapacity(capacity);
    }

    public CharArrayList() {
        this.a = CharArrays.DEFAULT_EMPTY_ARRAY;
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != CharArrays.DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = CharArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    @Override
    public void add(int index, char k) {
        this.ensureIndex(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    @Override
    public boolean add(char k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public char getChar(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(char k) {
        char[] a = this.a;
        for (int i = 0; i < this.size; ++i) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char k) {
        char[] a = this.a;
        int i = this.size;
        while (i-- != 0) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public char removeChar(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char[] a = this.a;
        char old = a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(a, index + 1, a, index, this.size - index);
        }
        assert (this.size <= a.length);
        return old;
    }

    @Override
    public boolean rem(char k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeChar(index);
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public char set(int index, char k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = this.a[index];
        this.a[index] = k;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public CharList subList(int from, int to) {
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new SubList(from, to);
    }

    @Override
    public void getElements(int from, char[] a, int offset, int length) {
        CharArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    @Override
    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void setElements(int index, char[] a, int offset, int length) {
        this.ensureIndex(index);
        CharArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(a, offset, this.a, index, length);
    }

    @Override
    public void forEach(CharConsumer action) {
        char[] a = this.a;
        for (int i = 0; i < this.size; ++i) {
            action.accept(a[i]);
        }
    }

    @Override
    public boolean addAll(int index, CharCollection c) {
        if (c instanceof CharList) {
            return this.addAll(index, (CharList)c);
        }
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        CharIterator i = c.iterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index++] = i.nextChar();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    public boolean addAll(int index, CharList l) {
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        l.getElements(0, this.a, index, n);
        this.size += n;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(CharCollection c) {
        char[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public boolean removeIf(CharPredicate filter) {
        char[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (filter.test(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public CharListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new CharListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < CharArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return CharArrayList.this.a[this.last];
            }

            @Override
            public char previousChar() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return CharArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(char k) {
                CharArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(char k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                CharArrayList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                CharArrayList.this.removeChar(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }

            @Override
            public void forEachRemaining(CharConsumer action) {
                char[] a = CharArrayList.this.a;
                while (this.pos < CharArrayList.this.size) {
                    ++this.pos;
                    this.last = this.last;
                    action.accept(a[this.last]);
                }
            }
        };
    }

    @Override
    public CharSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public void sort(CharComparator comp) {
        if (comp == null) {
            CharArrays.stableSort(this.a, 0, this.size);
        } else {
            CharArrays.stableSort(this.a, 0, this.size, comp);
        }
    }

    @Override
    public void unstableSort(CharComparator comp) {
        if (comp == null) {
            CharArrays.unstableSort(this.a, 0, this.size);
        } else {
            CharArrays.unstableSort(this.a, 0, this.size, comp);
        }
    }

    public CharArrayList clone() {
        CharArrayList cloned = null;
        if (this.getClass() == CharArrayList.class) {
            cloned = new CharArrayList(CharArrayList.copyArraySafe(this.a, this.size), false);
            cloned.size = this.size;
        } else {
            try {
                cloned = (CharArrayList)super.clone();
            }
            catch (CloneNotSupportedException err) {
                throw new InternalError(err);
            }
            cloned.a = CharArrayList.copyArraySafe(this.a, this.size);
        }
        return cloned;
    }

    public boolean equals(CharArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        char[] a1 = this.a;
        char[] a2 = l.a;
        if (a1 == a2 && s == l.size()) {
            return true;
        }
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof CharArrayList) {
            return this.equals((CharArrayList)o);
        }
        if (o instanceof SubList) {
            return ((SubList)o).equals(this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(CharArrayList l) {
        int i;
        int s1 = this.size();
        int s2 = l.size();
        char[] a1 = this.a;
        char[] a2 = l.a;
        if (a1 == a2 && s1 == s2) {
            return 0;
        }
        for (i = 0; i < s1 && i < s2; ++i) {
            char e1 = a1[i];
            char e2 = a2[i];
            int r = Character.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Character> l) {
        if (l instanceof CharArrayList) {
            return this.compareTo((CharArrayList)l);
        }
        if (l instanceof SubList) {
            return -((SubList)l).compareTo(this);
        }
        return super.compareTo(l);
    }

    private class SubList
    extends AbstractCharList.CharRandomAccessSubList {
        protected SubList(int from, int to) {
            super(CharArrayList.this, from, to);
        }

        private char[] getParentArray() {
            return CharArrayList.this.a;
        }

        @Override
        public char getChar(int i) {
            this.ensureRestrictedIndex(i);
            return CharArrayList.this.a[i + this.from];
        }

        @Override
        public CharListIterator listIterator(int index) {
            return new SubListIterator(index);
        }

        @Override
        public CharSpliterator spliterator() {
            return new SubListSpliterator();
        }

        boolean contentsEquals(char[] otherA, int otherAFrom, int otherATo) {
            if (CharArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return true;
            }
            if (otherATo - otherAFrom != this.size()) {
                return false;
            }
            int pos = this.from;
            int otherPos = otherAFrom;
            while (pos < this.to) {
                if (CharArrayList.this.a[pos++] == otherA[otherPos++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof List)) {
                return false;
            }
            if (o instanceof CharArrayList) {
                CharArrayList other = (CharArrayList)o;
                return this.contentsEquals(other.a, 0, other.size());
            }
            if (o instanceof SubList) {
                SubList other = (SubList)o;
                return this.contentsEquals(other.getParentArray(), other.from, other.to);
            }
            return super.equals(o);
        }

        int contentsCompareTo(char[] otherA, int otherAFrom, int otherATo) {
            if (CharArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return 0;
            }
            int i = this.from;
            int j = otherAFrom;
            while (i < this.to && i < otherATo) {
                char e1 = CharArrayList.this.a[i];
                char e2 = otherA[j];
                int r = Character.compare(e1, e2);
                if (r != 0) {
                    return r;
                }
                ++i;
                ++j;
            }
            return i < otherATo ? -1 : (i < this.to ? 1 : 0);
        }

        @Override
        public int compareTo(List<? extends Character> l) {
            if (l instanceof CharArrayList) {
                CharArrayList other = (CharArrayList)l;
                return this.contentsCompareTo(other.a, 0, other.size());
            }
            if (l instanceof SubList) {
                SubList other = (SubList)l;
                return this.contentsCompareTo(other.getParentArray(), other.from, other.to);
            }
            return super.compareTo(l);
        }

        private final class SubListIterator
        extends CharIterators.AbstractIndexBasedListIterator {
            SubListIterator(int index) {
                super(0, index);
            }

            @Override
            protected final char get(int i) {
                return CharArrayList.this.a[SubList.this.from + i];
            }

            @Override
            protected final void add(int i, char k) {
                SubList.this.add(i, k);
            }

            @Override
            protected final void set(int i, char k) {
                SubList.this.set(i, k);
            }

            @Override
            protected final void remove(int i) {
                SubList.this.removeChar(i);
            }

            @Override
            protected final int getMaxPos() {
                return SubList.this.to - SubList.this.from;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.pos++;
                return CharArrayList.this.a[SubList.this.from + this.lastReturned];
            }

            @Override
            public char previousChar() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.pos;
                return CharArrayList.this.a[SubList.this.from + this.pos];
            }

            @Override
            public void forEachRemaining(CharConsumer action) {
                char[] a = CharArrayList.this.a;
                int max = SubList.this.to - SubList.this.from;
                while (this.pos < max) {
                    ++this.pos;
                    this.lastReturned = this.lastReturned;
                    action.accept(a[SubList.this.from + this.lastReturned]);
                }
            }
        }

        private final class SubListSpliterator
        extends CharSpliterators.LateBindingSizeIndexBasedSpliterator {
            SubListSpliterator() {
                super(SubList.this.from);
            }

            private SubListSpliterator(int pos, int maxPos) {
                super(pos, maxPos);
            }

            @Override
            protected final int getMaxPosFromBackingStore() {
                return SubList.this.to;
            }

            @Override
            protected final char get(int i) {
                return CharArrayList.this.a[i];
            }

            @Override
            protected final SubListSpliterator makeForSplit(int pos, int maxPos) {
                return new SubListSpliterator(pos, maxPos);
            }

            @Override
            public boolean tryAdvance(CharConsumer action) {
                if (this.pos >= this.getMaxPos()) {
                    return false;
                }
                action.accept(CharArrayList.this.a[this.pos++]);
                return true;
            }

            @Override
            public void forEachRemaining(CharConsumer action) {
                char[] a = CharArrayList.this.a;
                int max = this.getMaxPos();
                while (this.pos < max) {
                    action.accept(a[this.pos++]);
                }
            }
        }
    }

    private final class Spliterator
    implements CharSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, charArrayList.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : CharArrayList.this.size;
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(CharConsumer action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(CharArrayList.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(CharConsumer action) {
            char[] a = CharArrayList.this.a;
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public CharSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

