/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.fastutil.doubles;

import java.io.Serializable;
import java.util.Comparator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.doubles.DoubleComparator;

public final class DoubleComparators {
    public static final DoubleComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final DoubleComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static DoubleComparator oppositeComparator(DoubleComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static DoubleComparator asDoubleComparator(final Comparator<? super Double> c) {
        if (c == null || c instanceof DoubleComparator) {
            return (DoubleComparator)c;
        }
        return new DoubleComparator(){

            @Override
            public int compare(double x, double y) {
                return c.compare(x, y);
            }

            @Override
            public int compare(Double x, Double y) {
                return c.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements DoubleComparator,
    Serializable {
        final DoubleComparator comparator;

        protected OppositeComparator(DoubleComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(double a, double b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final DoubleComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements DoubleComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(double a, double b) {
            return Double.compare(a, b);
        }

        @Override
        public DoubleComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements DoubleComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(double a, double b) {
            return -Double.compare(a, b);
        }

        @Override
        public DoubleComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

