/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.fastutil.floats;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.Size64;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.AbstractFloatList;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatArrays;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatCollection;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatComparator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatComparators;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatListIterator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatSpliterator;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatSpliterators;
import karate.com.linecorp.armeria.internal.shaded.fastutil.floats.FloatUnaryOperator;

public interface FloatList
extends FloatCollection,
Comparable<List<? extends Float>>,
List<Float> {
    @Override
    public FloatListIterator iterator();

    @Override
    default public FloatSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractFloatList.IndexBasedSpliterator(this, 0);
        }
        return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public FloatListIterator listIterator();

    public FloatListIterator listIterator(int var1);

    public FloatList subList(int var1, int var2);

    public void getElements(int var1, float[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(float[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index, float[] a) {
        this.setElements(index, a, 0, a.length);
    }

    default public void setElements(int index, float[] a, int offset, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        FloatArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        FloatListIterator iter2 = this.listIterator(index);
        int i = 0;
        while (i < length) {
            iter2.nextFloat();
            iter2.set(a[offset + i++]);
        }
    }

    @Override
    public boolean add(float var1);

    @Override
    public void add(int var1, float var2);

    @Override
    @Deprecated
    default public void add(int index, Float key) {
        this.add(index, key.floatValue());
    }

    @Override
    public float set(int var1, float var2);

    default public void replaceAll(FloatUnaryOperator operator) {
        FloatListIterator iter2 = this.listIterator();
        while (iter2.hasNext()) {
            iter2.set(operator.apply(iter2.nextFloat()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Float> operator) {
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof FloatUnaryOperator ? (FloatUnaryOperator)operator : operator::apply);
    }

    public float getFloat(int var1);

    public int indexOf(float var1);

    public int lastIndexOf(float var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return FloatCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Float get(int index) {
        return Float.valueOf(this.getFloat(index));
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public boolean add(Float k) {
        return this.add(k.floatValue());
    }

    public float removeFloat(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return FloatCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Float remove(int index) {
        return Float.valueOf(this.removeFloat(index));
    }

    @Override
    @Deprecated
    default public Float set(int index, Float k) {
        return Float.valueOf(this.set(index, k.floatValue()));
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Float> comparator) {
        this.sort(FloatComparators.asFloatComparator(comparator));
    }

    default public void sort(FloatComparator comparator) {
        float[] elements = this.toFloatArray();
        if (comparator == null) {
            FloatArrays.stableSort(elements);
        } else {
            FloatArrays.stableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

