/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.guava.base;

import javax.annotation.CheckForNull;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Optional;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

final class Absent<T>
extends Optional<T> {
    static final Absent<Object> INSTANCE = new Absent();

    static <T> Optional<T> withType() {
        return INSTANCE;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public T or(T defaultValue) {
        return Preconditions.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    @CheckForNull
    public T orNull() {
        return null;
    }

    public boolean equals(@CheckForNull Object object) {
        return object == this;
    }

    public int hashCode() {
        return 2040732332;
    }

    public String toString() {
        return "Optional.absent()";
    }
}

