/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import javax.annotation.CheckForNull;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.AbstractTable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.SparseImmutableTable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Table;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Tables;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.UnmodifiableIterator;

public abstract class ImmutableTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    public static <R, C, V> ImmutableTable<R, C, V> of() {
        return SparseImmutableTable.EMPTY;
    }

    static <R, C, V> Table.Cell<R, C, V> cellOf(R rowKey, C columnKey, V value) {
        return Tables.immutableCell(Preconditions.checkNotNull(rowKey, "rowKey"), Preconditions.checkNotNull(columnKey, "columnKey"), Preconditions.checkNotNull(value, "value"));
    }

    ImmutableTable() {
    }

    @Override
    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return (ImmutableSet)super.cellSet();
    }

    @Override
    abstract ImmutableSet<Table.Cell<R, C, V>> createCellSet();

    @Override
    final UnmodifiableIterator<Table.Cell<R, C, V>> cellIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    final Spliterator<Table.Cell<R, C, V>> cellSpliterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableMap<C, V> row(R rowKey) {
        Preconditions.checkNotNull(rowKey, "rowKey");
        return MoreObjects.firstNonNull((ImmutableMap)((ImmutableMap)this.rowMap()).get(rowKey), ImmutableMap.of());
    }

    @Override
    public abstract ImmutableMap<R, Map<C, V>> rowMap();

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final V put(R rowKey, C columnKey, V value) {
        throw new UnsupportedOperationException();
    }
}

