/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Function;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.AbstractTransformFuture;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.AsyncFunction;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.CollectionFuture;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.GwtFuturesCatchingSpecialization;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.ImmediateFuture;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.ListenableFuture;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.Uninterruptibles;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Futures
extends GwtFuturesCatchingSpecialization {
    public static <V> ListenableFuture<V> immediateFuture(V value) {
        if (value == null) {
            ListenableFuture<?> typedNull = ImmediateFuture.NULL;
            return typedNull;
        }
        return new ImmediateFuture<V>(value);
    }

    public static ListenableFuture<@Nullable Void> immediateVoidFuture() {
        return ImmediateFuture.NULL;
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.createAsync(input, function, executor);
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(input, function, executor);
    }

    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        CollectionFuture.ListFuture nullable;
        CollectionFuture.ListFuture nonNull = nullable = new CollectionFuture.ListFuture(ImmutableList.copyOf(futures), true);
        return nonNull;
    }

    @CanIgnoreReturnValue
    public static <V> V getDone(Future<V> future) throws ExecutionException {
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future);
    }
}

