/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.jctools.queues;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.IndexedQueueSizeUtil;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.LinkedArrayQueueUtil;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.MessagePassingQueue;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.MessagePassingQueueUtil;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.MpscBlockingConsumerArrayQueueConsumerFields;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.QueueProgressIndicators;
import karate.com.linecorp.armeria.internal.shaded.jctools.util.Pow2;
import karate.com.linecorp.armeria.internal.shaded.jctools.util.RangeUtil;
import karate.com.linecorp.armeria.internal.shaded.jctools.util.UnsafeRefArrayAccess;

public class MpscBlockingConsumerArrayQueue<E>
extends MpscBlockingConsumerArrayQueueConsumerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators,
BlockingQueue<E> {
    byte b000;
    byte b001;
    byte b002;
    byte b003;
    byte b004;
    byte b005;
    byte b006;
    byte b007;
    byte b010;
    byte b011;
    byte b012;
    byte b013;
    byte b014;
    byte b015;
    byte b016;
    byte b017;
    byte b020;
    byte b021;
    byte b022;
    byte b023;
    byte b024;
    byte b025;
    byte b026;
    byte b027;
    byte b030;
    byte b031;
    byte b032;
    byte b033;
    byte b034;
    byte b035;
    byte b036;
    byte b037;
    byte b040;
    byte b041;
    byte b042;
    byte b043;
    byte b044;
    byte b045;
    byte b046;
    byte b047;
    byte b050;
    byte b051;
    byte b052;
    byte b053;
    byte b054;
    byte b055;
    byte b056;
    byte b057;
    byte b060;
    byte b061;
    byte b062;
    byte b063;
    byte b064;
    byte b065;
    byte b066;
    byte b067;
    byte b070;
    byte b071;
    byte b072;
    byte b073;
    byte b074;
    byte b075;
    byte b076;
    byte b077;
    byte b100;
    byte b101;
    byte b102;
    byte b103;
    byte b104;
    byte b105;
    byte b106;
    byte b107;
    byte b110;
    byte b111;
    byte b112;
    byte b113;
    byte b114;
    byte b115;
    byte b116;
    byte b117;
    byte b120;
    byte b121;
    byte b122;
    byte b123;
    byte b124;
    byte b125;
    byte b126;
    byte b127;
    byte b130;
    byte b131;
    byte b132;
    byte b133;
    byte b134;
    byte b135;
    byte b136;
    byte b137;
    byte b140;
    byte b141;
    byte b142;
    byte b143;
    byte b144;
    byte b145;
    byte b146;
    byte b147;
    byte b150;
    byte b151;
    byte b152;
    byte b153;
    byte b154;
    byte b155;
    byte b156;
    byte b157;
    byte b160;
    byte b161;
    byte b162;
    byte b163;
    byte b164;
    byte b165;
    byte b166;
    byte b167;
    byte b170;
    byte b171;
    byte b172;
    byte b173;
    byte b174;
    byte b175;
    byte b176;
    byte b177;

    public MpscBlockingConsumerArrayQueue(int capacity) {
        super(Pow2.roundToPowerOfTwo(capacity) - 1 << 1, UnsafeRefArrayAccess.allocateRefArray(Pow2.roundToPowerOfTwo(capacity)));
        RangeUtil.checkGreaterThanOrEqual(capacity, 1, "capacity");
        this.soProducerLimit(Pow2.roundToPowerOfTwo(capacity) - 1 << 1);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() / 2L == this.lvProducerIndex() / 2L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    public boolean offerIfBelowThreshold(E e, int threshold) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        long mask = this.producerMask;
        long capacity = mask + 2L;
        threshold <<= 1;
        Object[] buffer = this.producerBuffer;
        while (true) {
            if (((pIndex = this.lvProducerIndex()) & 1L) == 1L) {
                if (!this.offerAndWakeup(buffer, mask, pIndex, e)) continue;
                return true;
            }
            long producerLimit = this.lvProducerLimit();
            long available = producerLimit - pIndex;
            long sizeEstimate = capacity - available;
            if (!(sizeEstimate < (long)threshold && producerLimit > pIndex || this.recalculateProducerLimit(pIndex, producerLimit, this.lvConsumerIndex(), capacity, threshold))) {
                return false;
            }
            if (this.casProducerIndex(pIndex, pIndex + 2L)) break;
        }
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        long mask = this.producerMask;
        Object[] buffer = this.producerBuffer;
        while (true) {
            if (((pIndex = this.lvProducerIndex()) & 1L) == 1L) {
                if (!this.offerAndWakeup(buffer, mask, pIndex, e)) continue;
                return true;
            }
            long producerLimit = this.lvProducerLimit();
            if (producerLimit <= pIndex && !this.recalculateProducerLimit(mask, pIndex, producerLimit)) {
                return false;
            }
            if (this.casProducerIndex(pIndex, pIndex + 2L)) break;
        }
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (!this.offer(e)) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.offer(e)) {
            return true;
        }
        throw new UnsupportedOperationException();
    }

    private boolean offerAndWakeup(E[] buffer, long mask, long pIndex, E e) {
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, mask);
        Thread consumerThread = this.lvBlocked();
        if (consumerThread == null) {
            return false;
        }
        if (!this.casProducerIndex(pIndex, pIndex + 1L)) {
            return false;
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        LockSupport.unpark(consumerThread);
        return true;
    }

    private boolean recalculateProducerLimit(long mask, long pIndex, long producerLimit) {
        return this.recalculateProducerLimit(pIndex, producerLimit, this.lvConsumerIndex(), mask + 2L, mask + 2L);
    }

    private boolean recalculateProducerLimit(long pIndex, long producerLimit, long cIndex, long bufferCapacity, long threshold) {
        long size;
        if (cIndex + bufferCapacity > pIndex) {
            this.casProducerLimit(producerLimit, cIndex + bufferCapacity);
        }
        return (size = pIndex - cIndex) < threshold && size < bufferCapacity;
    }

    @Override
    public E take() throws InterruptedException {
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            return (E)this.parkUntilNext(buffer, cIndex, offset, Long.MAX_VALUE);
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(cIndex + 2L);
        return (E)e;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            long timeoutNs = unit.toNanos(timeout);
            if (timeoutNs <= 0L) {
                return null;
            }
            return (E)this.parkUntilNext(buffer, cIndex, offset, timeoutNs);
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(cIndex + 2L);
        return (E)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E parkUntilNext(E[] buffer, long cIndex, long offset, long timeoutNs) throws InterruptedException {
        block7: {
            long pIndex = this.lvProducerIndex();
            if (cIndex == pIndex && this.casProducerIndex(pIndex, pIndex + 1L)) {
                this.soBlocked(Thread.currentThread());
                long deadlineNs = timeoutNs == Long.MAX_VALUE ? 0L : System.nanoTime() + timeoutNs;
                try {
                    do {
                        LockSupport.parkNanos(this, timeoutNs);
                        if (Thread.interrupted()) {
                            this.casProducerIndex(pIndex + 1L, pIndex);
                            throw new InterruptedException();
                        }
                        if ((this.lvProducerIndex() & 1L) != 0L) continue;
                        break block7;
                    } while ((timeoutNs = timeoutNs == Long.MAX_VALUE ? Long.MAX_VALUE : deadlineNs - System.nanoTime()) > 0L);
                    if (this.casProducerIndex(pIndex + 1L, pIndex)) {
                        E e = null;
                        return e;
                    }
                }
                finally {
                    this.soBlocked(null);
                }
            }
        }
        E e = MpscBlockingConsumerArrayQueue.spinWaitForElement(buffer, offset);
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(cIndex + 2L);
        return e;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity() - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long index = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            if (index != this.lvProducerIndex()) {
                e = MpscBlockingConsumerArrayQueue.spinWaitForElement(buffer, offset);
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(index + 2L);
        return (E)e;
    }

    private static <E> E spinWaitForElement(E[] buffer, long offset) {
        E e;
        while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
        }
        return e;
    }

    @Override
    public E peek() {
        Object[] buffer = this.consumerBuffer;
        long mask = this.consumerMask;
        long index = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null && index != this.lvProducerIndex()) {
            e = MpscBlockingConsumerArrayQueue.spinWaitForElement(buffer, offset);
        }
        return (E)e;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public int capacity() {
        return (int)(this.consumerMask + 2L >> 1);
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        long mask;
        Object[] buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        this.soConsumerIndex(index + 2L);
        return (E)e;
    }

    @Override
    public E relaxedPeek() {
        Object[] buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        long mask = this.consumerMask;
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(index, mask);
        return (E)UnsafeRefArrayAccess.lvRefElement(buffer, offset);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        long pIndex;
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        long mask = this.producerMask;
        Thread blockedConsumer = null;
        long batchLimit = 0L;
        long shiftedBatchSize = 2L * (long)limit;
        while (true) {
            pIndex = this.lvProducerIndex();
            long producerLimit = this.lvProducerLimit();
            if ((pIndex & 1L) == 1L) {
                blockedConsumer = this.lvBlocked();
                if (blockedConsumer == null) continue;
                if (!this.casProducerIndex(pIndex, pIndex + 1L)) {
                    blockedConsumer = null;
                    continue;
                }
                batchLimit = pIndex + 1L;
                --pIndex;
                break;
            }
            batchLimit = Math.min(producerLimit, pIndex + shiftedBatchSize);
            if (pIndex >= producerLimit) {
                if (!this.recalculateProducerLimit(mask, pIndex, producerLimit)) {
                    return 0;
                }
                batchLimit = Math.min(this.lvProducerLimit(), pIndex + shiftedBatchSize);
            }
            if (this.casProducerIndex(pIndex, batchLimit)) break;
        }
        int claimedSlots = (int)((batchLimit - pIndex) / 2L);
        Object[] buffer = this.producerBuffer;
        for (int i = 0; i < claimedSlots; ++i) {
            long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex + 2L * (long)i, mask);
            UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
        }
        if (blockedConsumer != null && this.lvBlocked() == blockedConsumer) {
            LockSupport.unpark(blockedConsumer);
        }
        return claimedSlots;
    }

    public int drain(MessagePassingQueue.Consumer<E> c, int limit, long timeout, TimeUnit unit) throws InterruptedException {
        if (limit == 0) {
            return 0;
        }
        int drained = this.drain(c, limit);
        if (drained != 0) {
            return drained;
        }
        E e = this.poll(timeout, unit);
        if (e == null) {
            return 0;
        }
        c.accept(e);
        return 1 + this.drain(c, limit - 1);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return MessagePassingQueueUtil.fillBounded(this, s);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.fill(this, s, wait, exit);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        return MessagePassingQueueUtil.drain(this, c, limit);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, w, exit);
    }
}

