/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.jctools.queues.atomic.unpadded;

import java.util.concurrent.atomic.AtomicReferenceArray;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.atomic.AtomicQueueUtil;
import karate.com.linecorp.armeria.internal.shaded.jctools.queues.atomic.unpadded.MpscChunkedAtomicUnpaddedArrayQueue;
import karate.com.linecorp.armeria.internal.shaded.jctools.util.Pow2;
import karate.com.linecorp.armeria.internal.shaded.jctools.util.RangeUtil;

public class MpscGrowableAtomicUnpaddedArrayQueue<E>
extends MpscChunkedAtomicUnpaddedArrayQueue<E> {
    public MpscGrowableAtomicUnpaddedArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableAtomicUnpaddedArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(AtomicQueueUtil.length(buffer), maxSize, "buffer.length");
        int newSize = 2 * (AtomicQueueUtil.length(buffer) - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

