/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.reflections;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Supplier;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Multimaps;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.SetMultimap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import karate.com.linecorp.armeria.internal.shaded.reflections.Configuration;
import karate.com.linecorp.armeria.internal.shaded.reflections.ReflectionsException;

public class Store {
    private transient boolean concurrent;
    private final Map<String, Multimap<String, String>> storeMap = new HashMap<String, Multimap<String, String>>();

    protected Store() {
        this.concurrent = false;
    }

    public Store(Configuration configuration) {
        this.concurrent = configuration.getExecutorService() != null;
    }

    public Set<String> keySet() {
        return this.storeMap.keySet();
    }

    public Multimap<String, String> getOrCreate(String index) {
        Multimap<String, String> mmap = this.storeMap.get(index);
        if (mmap == null) {
            SetMultimap<String, String> multimap = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                @Override
                public Set<String> get() {
                    return Sets.newSetFromMap(new ConcurrentHashMap());
                }
            });
            mmap = this.concurrent ? Multimaps.synchronizedSetMultimap(multimap) : multimap;
            this.storeMap.put(index, mmap);
        }
        return mmap;
    }

    public Multimap<String, String> get(String index) {
        Multimap<String, String> mmap = this.storeMap.get(index);
        if (mmap == null) {
            throw new ReflectionsException("Scanner " + index + " was not configured");
        }
        return mmap;
    }

    public Iterable<String> get(String index, Iterable<String> keys) {
        Multimap<String, String> mmap = this.get(index);
        IterableChain<String> result = new IterableChain<String>();
        for (String key : keys) {
            ((IterableChain)result).addAll(mmap.get(key));
        }
        return result;
    }

    private static class IterableChain<T>
    implements Iterable<T> {
        private final List<Iterable<T>> chain = Lists.newArrayList();

        private IterableChain() {
        }

        private void addAll(Iterable<T> iterable) {
            this.chain.add(iterable);
        }

        @Override
        public Iterator<T> iterator() {
            return Iterables.concat(this.chain).iterator();
        }
    }
}

