/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.reflections.adapters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import karate.com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import karate.com.linecorp.armeria.internal.shaded.reflections.adapters.MetadataAdapter;
import karate.com.linecorp.armeria.internal.shaded.reflections.vfs.Vfs;

public class JavaReflectionAdapter
implements MetadataAdapter<Class, Field, Member> {
    @Override
    public List<String> getClassAnnotationNames(Class aClass) {
        return this.getAnnotationNames(aClass.getDeclaredAnnotations());
    }

    @Override
    public Class getOfCreateClassObject(Vfs.File file) throws Exception {
        return this.getOfCreateClassObject(file, null);
    }

    public Class getOfCreateClassObject(Vfs.File file, ClassLoader ... loaders) throws Exception {
        String name = file.getRelativePath().replace("/", ".").replace(".class", "");
        return ReflectionUtils.forName(name, loaders);
    }

    @Override
    public String getClassName(Class cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(Class cls) {
        Class superclass = cls.getSuperclass();
        return superclass != null ? superclass.getName() : "";
    }

    @Override
    public List<String> getInterfacesNames(Class cls) {
        Class<?>[] classes = cls.getInterfaces();
        ArrayList<String> names = new ArrayList<String>(classes != null ? classes.length : 0);
        if (classes != null) {
            for (Class<?> cls1 : classes) {
                names.add(cls1.getName());
            }
        }
        return names;
    }

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class");
    }

    private List<String> getAnnotationNames(Annotation[] annotations) {
        ArrayList<String> names = new ArrayList<String>(annotations.length);
        for (Annotation annotation : annotations) {
            names.add(annotation.annotationType().getName());
        }
        return names;
    }
}

