/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.shaded.reflections.util;

import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Predicate;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ObjectArrays;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import karate.com.linecorp.armeria.internal.shaded.reflections.Configuration;
import karate.com.linecorp.armeria.internal.shaded.reflections.Reflections;
import karate.com.linecorp.armeria.internal.shaded.reflections.adapters.JavaReflectionAdapter;
import karate.com.linecorp.armeria.internal.shaded.reflections.adapters.JavassistAdapter;
import karate.com.linecorp.armeria.internal.shaded.reflections.adapters.MetadataAdapter;
import karate.com.linecorp.armeria.internal.shaded.reflections.scanners.Scanner;
import karate.com.linecorp.armeria.internal.shaded.reflections.scanners.SubTypesScanner;
import karate.com.linecorp.armeria.internal.shaded.reflections.scanners.TypeAnnotationsScanner;

public class ConfigurationBuilder
implements Configuration {
    @Nonnull
    private Set<Scanner> scanners = Sets.newHashSet(new TypeAnnotationsScanner(), new SubTypesScanner());
    @Nonnull
    private Set<URL> urls = Sets.newHashSet();
    protected MetadataAdapter metadataAdapter;
    @Nullable
    private Predicate<String> inputsFilter;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private ClassLoader[] classLoaders;
    private boolean expandSuperTypes = true;

    @Override
    @Nonnull
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Sets.newHashSet(scanners));
        return this;
    }

    @Override
    @Nonnull
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(@Nonnull Collection<URL> urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        if (this.metadataAdapter != null) {
            return this.metadataAdapter;
        }
        try {
            this.metadataAdapter = new JavassistAdapter();
            return this.metadataAdapter;
        }
        catch (Throwable e) {
            if (Reflections.log != null) {
                Reflections.log.warn("could not create JavassistAdapter, using JavaReflectionAdapter", e);
            }
            this.metadataAdapter = new JavaReflectionAdapter();
            return this.metadataAdapter;
        }
    }

    @Override
    @Nullable
    public Predicate<String> getInputsFilter() {
        return this.inputsFilter;
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    @Override
    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean shouldExpandSuperTypes() {
        return this.expandSuperTypes;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        this.classLoaders = this.classLoaders == null ? classLoaders : ObjectArrays.concat(this.classLoaders, classLoaders, ClassLoader.class);
        return this;
    }
}

