/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.server.RouteUtil;
import karate.com.linecorp.armeria.server.PathMapping;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.RoutingResultBuilder;

abstract class AbstractPathMapping
implements PathMapping {
    AbstractPathMapping() {
    }

    static String mappedPath(String prefix, String path) {
        int length = prefix.length();
        if (length == 0 || "/".equals(prefix)) {
            return path;
        }
        if (prefix.charAt(length - 1) == '/') {
            --length;
        }
        return path.substring(length);
    }

    @Override
    public final PathMapping withPrefix(String prefix) {
        if ("/".equals(prefix = RouteUtil.ensureAbsolutePath(prefix, "prefix"))) {
            return this;
        }
        return this.doWithPrefix(prefix.charAt(prefix.length() - 1) == '/' ? prefix : prefix + '/');
    }

    abstract PathMapping doWithPrefix(String var1);

    @Override
    @Nullable
    public final RoutingResultBuilder apply(RoutingContext routingCtx) {
        RouteUtil.ensureAbsolutePath(Objects.requireNonNull(routingCtx, "routingCtx").path(), "path");
        return this.doApply(routingCtx);
    }

    @Nullable
    abstract RoutingResultBuilder doApply(RoutingContext var1);

    public String toString() {
        return this.patternString();
    }
}

