/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.common.RequestId;
import karate.com.linecorp.armeria.common.SuccessFunction;
import karate.com.linecorp.armeria.common.util.BlockingTaskExecutor;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.server.AbstractBindingBuilder;
import karate.com.linecorp.armeria.server.DefaultServiceConfigSetters;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.MultipartRemovalStrategy;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.ServiceConfigBuilder;
import karate.com.linecorp.armeria.server.ServiceConfigSetters;
import karate.com.linecorp.armeria.server.ServiceErrorHandler;
import karate.com.linecorp.armeria.server.ServiceNaming;
import karate.com.linecorp.armeria.server.ServiceWithRoutes;
import karate.com.linecorp.armeria.server.logging.AccessLogWriter;
import karate.io.netty.channel.EventLoopGroup;

abstract class AbstractServiceBindingBuilder<SELF extends AbstractServiceBindingBuilder<SELF>>
extends AbstractBindingBuilder<SELF>
implements ServiceConfigSetters<SELF> {
    private final DefaultServiceConfigSetters defaultServiceConfigSetters = new DefaultServiceConfigSetters();

    AbstractServiceBindingBuilder(Set<String> contextPaths) {
        super(contextPaths);
    }

    @Override
    final SELF self() {
        return (SELF)this;
    }

    @Override
    public SELF requestTimeout(Duration requestTimeout) {
        return (SELF)this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    @Override
    public SELF requestTimeoutMillis(long requestTimeoutMillis) {
        this.defaultServiceConfigSetters.requestTimeoutMillis(requestTimeoutMillis);
        return (SELF)this.self();
    }

    @Override
    public SELF maxRequestLength(long maxRequestLength) {
        this.defaultServiceConfigSetters.maxRequestLength(maxRequestLength);
        return (SELF)this.self();
    }

    @Override
    public SELF verboseResponses(boolean verboseResponses) {
        this.defaultServiceConfigSetters.verboseResponses(verboseResponses);
        return (SELF)this.self();
    }

    @Override
    public SELF accessLogFormat(String accessLogFormat) {
        return (SELF)this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), true);
    }

    @Override
    public SELF accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.accessLogWriter(accessLogWriter, shutdownOnStop);
        return (SELF)this.self();
    }

    @Override
    public SELF decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        this.defaultServiceConfigSetters.decorator((Function)decorator);
        return (SELF)this.self();
    }

    @Override
    public SELF decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        this.defaultServiceConfigSetters.decorators((Function[])decorators);
        return (SELF)this.self();
    }

    @Override
    public SELF decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        this.defaultServiceConfigSetters.decorators((Iterable)decorators);
        return (SELF)this.self();
    }

    @Override
    public SELF defaultServiceName(String defaultServiceName) {
        this.defaultServiceConfigSetters.defaultServiceName(defaultServiceName);
        return (SELF)this.self();
    }

    @Override
    public SELF defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceConfigSetters.defaultServiceNaming(defaultServiceNaming);
        return (SELF)this.self();
    }

    @Override
    public SELF defaultLogName(String defaultLogName) {
        this.defaultServiceConfigSetters.defaultLogName(defaultLogName);
        return (SELF)this.self();
    }

    @Override
    public SELF blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return (SELF)this.self();
    }

    @Override
    public SELF blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return (SELF)this.self();
    }

    @Override
    public SELF blockingTaskExecutor(int numThreads) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(numThreads);
        return (SELF)this.self();
    }

    @Override
    public SELF successFunction(SuccessFunction successFunction) {
        this.defaultServiceConfigSetters.successFunction(successFunction);
        return (SELF)this.self();
    }

    @Override
    public SELF requestAutoAbortDelay(Duration delay) {
        this.defaultServiceConfigSetters.requestAutoAbortDelay(delay);
        return (SELF)this.self();
    }

    @Override
    public SELF requestAutoAbortDelayMillis(long delayMillis) {
        this.defaultServiceConfigSetters.requestAutoAbortDelayMillis(delayMillis);
        return (SELF)this.self();
    }

    @Override
    public SELF multipartUploadsLocation(Path multipartUploadsLocation) {
        this.defaultServiceConfigSetters.multipartUploadsLocation(multipartUploadsLocation);
        return (SELF)this.self();
    }

    @Override
    public SELF multipartRemovalStrategy(MultipartRemovalStrategy removalStrategy) {
        this.defaultServiceConfigSetters.multipartRemovalStrategy(removalStrategy);
        return (SELF)this.self();
    }

    @Override
    public SELF serviceWorkerGroup(EventLoopGroup serviceWorkerGroup, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.serviceWorkerGroup(serviceWorkerGroup, shutdownOnStop);
        return (SELF)this.self();
    }

    @Override
    public SELF serviceWorkerGroup(int numThreads) {
        this.defaultServiceConfigSetters.serviceWorkerGroup(numThreads);
        return (SELF)this.self();
    }

    @Override
    public SELF requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.defaultServiceConfigSetters.requestIdGenerator((Function)requestIdGenerator);
        return (SELF)this.self();
    }

    @Override
    public SELF addHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.addHeader(name, value);
        return (SELF)this.self();
    }

    @Override
    public SELF addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.addHeaders((Iterable)defaultHeaders);
        return (SELF)this.self();
    }

    @Override
    public SELF setHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.setHeader(name, value);
        return (SELF)this.self();
    }

    @Override
    public SELF setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.setHeaders((Iterable)defaultHeaders);
        return (SELF)this.self();
    }

    @Override
    public SELF errorHandler(ServiceErrorHandler serviceErrorHandler) {
        this.defaultServiceConfigSetters.errorHandler(serviceErrorHandler);
        return (SELF)this.self();
    }

    @Override
    public SELF contextHook(Supplier<? extends AutoCloseable> contextHook) {
        this.defaultServiceConfigSetters.contextHook((Supplier)contextHook);
        return (SELF)this.self();
    }

    abstract void serviceConfigBuilder(ServiceConfigBuilder var1);

    final void build0(HttpService service) {
        ServiceWithRoutes serviceWithRoutes = service.as(ServiceWithRoutes.class);
        Set fallbackRoutes = MoreObjects.firstNonNull(serviceWithRoutes != null ? serviceWithRoutes.routes() : null, ImmutableSet.of());
        List<Route> routes = this.buildRouteList(fallbackRoutes);
        HttpService decoratedService = this.defaultServiceConfigSetters.decorator().apply(service);
        for (String contextPath : this.contextPaths()) {
            for (Route route : routes) {
                ServiceConfigBuilder serviceConfigBuilder = this.defaultServiceConfigSetters.toServiceConfigBuilder(route, contextPath, decoratedService);
                this.serviceConfigBuilder(serviceConfigBuilder);
            }
        }
    }
}

