/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import karate.com.linecorp.armeria.common.logging.RequestLog;
import karate.com.linecorp.armeria.common.util.SafeCloseable;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.TransientServiceOption;
import karate.com.linecorp.armeria.server.logging.AccessLogWriter;

final class AccessLogWriterUtil {
    static void maybeWriteAccessLog(ServiceRequestContext reqCtx) {
        ServiceConfig config = reqCtx.config();
        if (AccessLogWriterUtil.shouldWriteAccessLog(config)) {
            reqCtx.log().whenComplete().thenAccept(log -> {
                try (SafeCloseable ignored = reqCtx.push();){
                    config.accessLogWriter().log((RequestLog)log);
                }
            });
        }
    }

    private static boolean shouldWriteAccessLog(ServiceConfig config) {
        return config.accessLogWriter() != AccessLogWriter.disabled() && config.transientServiceOptions().contains((Object)TransientServiceOption.WITH_ACCESS_LOGGING);
    }

    private AccessLogWriterUtil() {
    }
}

