/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.Routed;
import karate.com.linecorp.armeria.server.Router;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.io.micrometer.core.instrument.MeterRegistry;

final class CompositeRouter<I, O>
implements Router<O> {
    private final List<Router<I>> delegates;
    private final Function<Routed<I>, Routed<O>> resultMapper;

    CompositeRouter(List<Router<I>> delegates, Function<Routed<I>, Routed<O>> resultMapper) {
        this.delegates = Objects.requireNonNull(delegates, "delegates");
        this.resultMapper = Objects.requireNonNull(resultMapper, "resultMapper");
    }

    @Override
    public Routed<O> find(RoutingContext routingCtx) {
        for (Router<I> delegate : this.delegates) {
            Routed<I> result = delegate.find(routingCtx);
            if (!result.isPresent()) continue;
            return this.resultMapper.apply(result);
        }
        return Routed.empty();
    }

    @Override
    public List<Routed<O>> findAll(RoutingContext routingContext) {
        int numDelegates = this.delegates.size();
        switch (numDelegates) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return this.delegates.get(0).findAll(routingContext).stream().map(this.resultMapper).collect(ImmutableList.toImmutableList());
            }
        }
        return this.delegates.stream().flatMap(delegate -> delegate.findAll(routingContext).stream()).map(this.resultMapper).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean registerMetrics(MeterRegistry registry, MeterIdPrefix idPrefix) {
        int numDelegates = this.delegates.size();
        switch (numDelegates) {
            case 0: {
                return false;
            }
            case 1: {
                return this.delegates.get(0).registerMetrics(registry, idPrefix);
            }
        }
        boolean registered = false;
        for (int i = 0; i < numDelegates; ++i) {
            MeterIdPrefix delegateIdPrefix = idPrefix.withTags("index", String.valueOf(i));
            if (!this.delegates.get(i).registerMetrics(registry, delegateIdPrefix)) continue;
            registered = true;
        }
        return registered;
    }

    @Override
    public void dump(OutputStream output) {
        this.delegates.forEach(delegate -> delegate.dump(output));
    }
}

