/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import karate.com.linecorp.armeria.server.ServerMetrics;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelHandler;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelInboundHandlerAdapter;
import karate.io.netty.channel.ChannelOption;
import karate.io.netty.util.concurrent.Future;
import karate.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class ConnectionLimitingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLimitingHandler.class);
    private final Set<Channel> childChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Channel> unmodifiableChildChannels = Collections.unmodifiableSet(this.childChannels);
    private final int maxNumConnections;
    private final ServerMetrics serverMetrics;
    private final AtomicBoolean loggingScheduled = new AtomicBoolean();
    private final LongAdder numDroppedConnections = new LongAdder();

    ConnectionLimitingHandler(int maxNumConnections, ServerMetrics serverMetrics) {
        this.maxNumConnections = ConnectionLimitingHandler.validateMaxNumConnections(maxNumConnections);
        this.serverMetrics = serverMetrics;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel child = (Channel)msg;
        int conn = this.serverMetrics.increaseActiveConnectionsAndGet();
        if (conn > 0 && conn <= this.maxNumConnections) {
            this.childChannels.add(child);
            child.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                this.childChannels.remove(child);
                this.serverMetrics.decreaseActiveConnections();
            }));
            super.channelRead(ctx, msg);
        } else {
            this.serverMetrics.decreaseActiveConnections();
            child.config().setOption(ChannelOption.SO_LINGER, 0);
            child.unsafe().closeForcibly();
            this.numDroppedConnections.increment();
            if (this.loggingScheduled.compareAndSet(false, true)) {
                ctx.executor().schedule(this::writeNumDroppedConnectionsLog, 1L, TimeUnit.SECONDS);
            }
        }
    }

    private void writeNumDroppedConnectionsLog() {
        this.loggingScheduled.set(false);
        long dropped = this.numDroppedConnections.sumThenReset();
        if (dropped > 0L) {
            logger.warn("Dropped {} connection(s) to limit the number of open connections to {}", (Object)dropped, (Object)this.maxNumConnections);
        }
    }

    public int maxNumConnections() {
        return this.maxNumConnections;
    }

    public int numConnections() {
        return this.serverMetrics.activeConnections();
    }

    public Set<Channel> children() {
        return this.unmodifiableChildChannels;
    }

    public static int validateMaxNumConnections(int maxNumConnections) {
        if (maxNumConnections <= 0) {
            throw new IllegalArgumentException("maxNumConnections: " + maxNumConnections + " (expected: > 0)");
        }
        return maxNumConnections;
    }
}

