/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.server.CorsHeaderUtil;
import karate.com.linecorp.armeria.server.ServerErrorHandler;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.cors.CorsService;

final class CorsServerErrorHandler
implements ServerErrorHandler {
    ServerErrorHandler serverErrorHandler;

    CorsServerErrorHandler(ServerErrorHandler serverErrorHandler) {
        this.serverErrorHandler = serverErrorHandler;
    }

    @Override
    @Nullable
    public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig serviceConfig, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.serverErrorHandler.renderStatus(ctx, serviceConfig, headers, status, description, cause);
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        CorsService corsService = ctx.findService(CorsService.class);
        if (CorsServerErrorHandler.shouldSetCorsHeaders(corsService, ctx)) {
            assert (corsService != null);
            ctx.mutateAdditionalResponseHeaders(builder -> CorsHeaderUtil.setCorsResponseHeaders(ctx, ctx.request(), builder, corsService.config()));
        }
        return this.serverErrorHandler.onServiceException(ctx, cause);
    }

    private static boolean shouldSetCorsHeaders(@Nullable CorsService corsService, ServiceRequestContext ctx) {
        if (corsService == null) {
            return false;
        }
        if (CorsHeaderUtil.isCorsHeadersSet(ctx)) {
            return false;
        }
        RequestHeaders headers = ctx.request().headers();
        if (ArmeriaHttpUtil.isCorsPreflightRequest(headers)) {
            return false;
        }
        return !CorsHeaderUtil.isForbiddenOrigin(corsService.config(), ctx, headers);
    }

    @Override
    @Nullable
    public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.serverErrorHandler.onProtocolViolation(config, headers, status, description, cause);
    }
}

