/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.SystemInfo;
import karate.com.linecorp.armeria.internal.common.InboundTrafficController;
import karate.com.linecorp.armeria.server.AggregatingDecodedHttpRequest;
import karate.com.linecorp.armeria.server.EmptyContentDecodedHttpRequest;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.Routed;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.StreamingDecodedHttpRequest;
import karate.io.netty.channel.EventLoop;

interface DecodedHttpRequest
extends HttpRequest {
    public static DecodedHttpRequest of(boolean endOfStream, EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, InboundTrafficController inboundTrafficController, RoutingContext routingCtx) {
        long requestStartTimeNanos = System.nanoTime();
        long requestStartTimeMicros = SystemInfo.currentTimeMicros();
        if (!routingCtx.hasResult()) {
            return new EmptyContentDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, routingCtx, ExchangeType.RESPONSE_STREAMING, requestStartTimeNanos, requestStartTimeMicros);
        }
        ServiceConfig config = routingCtx.result().value();
        HttpService service = config.service();
        ExchangeType exchangeType = service.exchangeType(routingCtx);
        if (endOfStream) {
            return new EmptyContentDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros);
        }
        if (exchangeType.isRequestStreaming()) {
            return new StreamingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, inboundTrafficController, config.maxRequestLength(), routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros, false, false);
        }
        return new AggregatingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, config.maxRequestLength(), routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros);
    }

    public int id();

    public int streamId();

    public boolean isKeepAlive();

    public void init(ServiceRequestContext var1);

    public RoutingContext routingContext();

    @Nullable
    public Routed<ServiceConfig> route();

    public void close();

    public void close(Throwable var1);

    public boolean isClosedSuccessfully();

    public void setResponse(HttpResponse var1);

    public void abortResponse(Throwable var1, boolean var2);

    public boolean isResponseAborted();

    @Nullable
    default public CompletableFuture<Void> whenAggregated() {
        return null;
    }

    public ExchangeType exchangeType();

    public long requestStartTimeNanos();

    public long requestStartTimeMicros();

    default public boolean isHttp1WebSocket() {
        return false;
    }

    default public void setShouldResetOnlyIfRemoteIsOpen(boolean shouldResetOnlyIfRemoteIsOpen) {
    }

    default public boolean shouldResetOnlyIfRemoteIsOpen() {
        return false;
    }
}

