/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import javax.annotation.Nonnull;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.ContentTooLargeException;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.internal.common.RequestContextExtension;
import karate.com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.DecodedHttpRequest;
import karate.com.linecorp.armeria.server.HttpResponseException;
import karate.com.linecorp.armeria.server.HttpStatusException;
import karate.com.linecorp.armeria.server.RequestCancellationException;
import karate.com.linecorp.armeria.server.RequestTimeoutException;
import karate.com.linecorp.armeria.server.ServerErrorHandler;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.annotation.AnnotatedService;

final class DefaultServerErrorHandler
extends Enum<DefaultServerErrorHandler>
implements ServerErrorHandler {
    public static final /* enum */ DefaultServerErrorHandler INSTANCE = new DefaultServerErrorHandler();
    private static final /* synthetic */ DefaultServerErrorHandler[] $VALUES;

    public static DefaultServerErrorHandler[] values() {
        return (DefaultServerErrorHandler[])$VALUES.clone();
    }

    public static DefaultServerErrorHandler valueOf(String name) {
        return Enum.valueOf(DefaultServerErrorHandler.class, name);
    }

    @Override
    @Nonnull
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        boolean isAnnotatedService;
        boolean bl = isAnnotatedService = ctx.config().service().as(AnnotatedService.class) != null;
        if (isAnnotatedService && cause instanceof IllegalArgumentException) {
            return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), HttpStatus.BAD_REQUEST, cause);
        }
        if (cause instanceof HttpStatusException || cause instanceof HttpResponseException) {
            return HttpResponse.ofFailure(cause);
        }
        if (cause instanceof ContentTooLargeException) {
            return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), HttpStatus.REQUEST_ENTITY_TOO_LARGE, cause);
        }
        if (cause instanceof RequestCancellationException) {
            return HttpResponse.ofFailure(cause);
        }
        if (cause instanceof RequestTimeoutException) {
            RequestContextExtension ctxExtension = ctx.as(RequestContextExtension.class);
            assert (ctxExtension != null);
            DecodedHttpRequest request = (DecodedHttpRequest)ctxExtension.originalRequest();
            HttpStatus status = request.isClosedSuccessfully() ? HttpStatus.SERVICE_UNAVAILABLE : HttpStatus.REQUEST_TIMEOUT;
            return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), status, cause);
        }
        return DefaultServerErrorHandler.internalRenderStatus(ctx, ctx.request().headers(), HttpStatus.INTERNAL_SERVER_ERROR, cause);
    }

    private static HttpResponse internalRenderStatus(ServiceRequestContext ctx, RequestHeaders headers, HttpStatus status, @Nullable Throwable cause) {
        ServiceConfig serviceConfig = ctx.config();
        AggregatedHttpResponse res = serviceConfig.server().config().errorHandler().renderStatus(ctx, serviceConfig, headers, status, null, cause);
        assert (res != null);
        return res.toHttpResponse();
    }

    @Override
    @Nonnull
    public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        HttpData content;
        if (status.isContentAlwaysEmpty()) {
            return AggregatedHttpResponse.of(ResponseHeaders.of(status));
        }
        try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
            StringBuilder buf = ttl.stringBuilder();
            buf.append("Status: ").append(status.codeAsText()).append('\n');
            buf.append("Description: ").append(MoreObjects.firstNonNull(description, status.reasonPhrase())).append('\n');
            if (cause != null && config.verboseResponses() && !status.isSuccess()) {
                buf.append("Stack trace:\n");
                buf.append(Exceptions.traceText(cause));
            }
            content = HttpData.ofUtf8(buf);
        }
        return AggregatedHttpResponse.of(status, MediaType.PLAIN_TEXT_UTF_8, content);
    }

    private static /* synthetic */ DefaultServerErrorHandler[] $values() {
        return new DefaultServerErrorHandler[]{INSTANCE};
    }

    static {
        $VALUES = DefaultServerErrorHandler.$values();
    }
}

