/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.server.RouteUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.server.AbstractPathMapping;
import karate.com.linecorp.armeria.server.PathMapping;
import karate.com.linecorp.armeria.server.RoutePathType;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.RoutingResult;
import karate.com.linecorp.armeria.server.RoutingResultBuilder;

final class ExactPathMapping
extends AbstractPathMapping {
    private static final Pattern ESCAPE_COLON = Pattern.compile("/\\\\:");
    private final String prefix;
    private final String exactPath;
    private final List<String> paths;

    ExactPathMapping(String exactPath) {
        this("", exactPath);
    }

    private ExactPathMapping(String prefix, String exactPath) {
        if (!Flags.allowSemicolonInPathComponent()) {
            Preconditions.checkArgument(prefix.indexOf(59) < 0, "prefix: %s (expected not to have a ';')", (Object)prefix);
            Preconditions.checkArgument(exactPath.indexOf(59) < 0, "exactPath: %s (expected not to have a ';')", (Object)exactPath);
        }
        this.prefix = prefix;
        RouteUtil.ensureAbsolutePath(exactPath, "exactPath");
        this.exactPath = exactPath = ESCAPE_COLON.matcher(exactPath).replaceAll("/:");
        this.paths = ImmutableList.of(exactPath, exactPath);
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        return new ExactPathMapping(prefix, ArmeriaHttpUtil.concatPaths(prefix, this.exactPath));
    }

    @Override
    @Nullable
    RoutingResultBuilder doApply(RoutingContext routingCtx) {
        return this.exactPath.equals(routingCtx.path()) ? RoutingResult.builder().path(ExactPathMapping.mappedPath(this.prefix, routingCtx.path())).query(routingCtx.query()) : null;
    }

    @Override
    public Set<String> paramNames() {
        return ImmutableSet.of();
    }

    @Override
    public String patternString() {
        return this.exactPath;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.EXACT;
    }

    @Override
    public List<String> paths() {
        return this.paths;
    }

    public int hashCode() {
        return this.exactPath.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof ExactPathMapping && (this == obj || this.exactPath.equals(((ExactPathMapping)obj).exactPath));
    }
}

