/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.LongAdder;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Ticker;

abstract class GracefulShutdownSupport {
    private final LongAdder pendingResponses = new LongAdder();

    GracefulShutdownSupport() {
    }

    static GracefulShutdownSupport create(Duration quietPeriod, Executor blockingTaskExecutor) {
        return GracefulShutdownSupport.create(quietPeriod, blockingTaskExecutor, Ticker.systemTicker());
    }

    static GracefulShutdownSupport create(Duration quietPeriod, Executor blockingTaskExecutor, Ticker ticker) {
        return new DefaultGracefulShutdownSupport(quietPeriod, blockingTaskExecutor, ticker);
    }

    static GracefulShutdownSupport createDisabled() {
        return new DisabledGracefulShutdownSupport();
    }

    final void inc() {
        this.pendingResponses.increment();
    }

    void dec() {
        this.pendingResponses.decrement();
    }

    final long pendingResponses() {
        return this.pendingResponses.sum();
    }

    abstract boolean isShuttingDown();

    abstract boolean completedQuietPeriod();

    private static final class DefaultGracefulShutdownSupport
    extends GracefulShutdownSupport {
        private final long quietPeriodNanos;
        private final Ticker ticker;
        private final Executor blockingTaskExecutor;
        private long lastResTimeNanos;
        private volatile long shutdownStartTimeNanos;

        DefaultGracefulShutdownSupport(Duration quietPeriod, Executor blockingTaskExecutor, Ticker ticker) {
            this.quietPeriodNanos = quietPeriod.toNanos();
            this.blockingTaskExecutor = blockingTaskExecutor;
            this.ticker = ticker;
        }

        @Override
        void dec() {
            this.lastResTimeNanos = this.readTicker();
            super.dec();
        }

        @Override
        boolean isShuttingDown() {
            return this.shutdownStartTimeNanos != 0L;
        }

        @Override
        boolean completedQuietPeriod() {
            if (this.shutdownStartTimeNanos == 0L) {
                this.shutdownStartTimeNanos = this.readTicker();
            }
            if (this.pendingResponses() != 0L || !this.completedBlockingTasks()) {
                return false;
            }
            long shutdownStartTimeNanos = this.shutdownStartTimeNanos;
            long currentTimeNanos = this.ticker.read();
            long durationNanos = this.lastResTimeNanos != 0L ? Math.min(currentTimeNanos - shutdownStartTimeNanos, currentTimeNanos - this.lastResTimeNanos) : currentTimeNanos - shutdownStartTimeNanos;
            return durationNanos >= this.quietPeriodNanos;
        }

        private long readTicker() {
            return this.ticker.read() | 1L;
        }

        private boolean completedBlockingTasks() {
            if (!(this.blockingTaskExecutor instanceof ThreadPoolExecutor)) {
                return true;
            }
            ThreadPoolExecutor threadPool = (ThreadPoolExecutor)this.blockingTaskExecutor;
            return threadPool.getQueue().isEmpty() && threadPool.getActiveCount() == 0;
        }
    }

    private static final class DisabledGracefulShutdownSupport
    extends GracefulShutdownSupport {
        private volatile boolean shuttingDown;

        private DisabledGracefulShutdownSupport() {
        }

        @Override
        boolean isShuttingDown() {
            return this.shuttingDown;
        }

        @Override
        boolean completedQuietPeriod() {
            this.shuttingDown = true;
            return true;
        }
    }
}

