/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.net.URISyntaxException;
import karate.com.linecorp.armeria.common.ClosedSessionException;
import karate.com.linecorp.armeria.common.ContentTooLargeException;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.HttpRequestWriter;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.ProtocolViolationException;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.RequestTarget;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.SystemInfo;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.common.InboundTrafficController;
import karate.com.linecorp.armeria.internal.common.InitiateConnectionShutdown;
import karate.com.linecorp.armeria.internal.common.KeepAliveHandler;
import karate.com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import karate.com.linecorp.armeria.internal.common.websocket.WebSocketUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import karate.com.linecorp.armeria.server.DecodedHttpRequest;
import karate.com.linecorp.armeria.server.DecodedHttpRequestWriter;
import karate.com.linecorp.armeria.server.EmptyContentDecodedHttpRequest;
import karate.com.linecorp.armeria.server.Http2ServerConnectionHandler;
import karate.com.linecorp.armeria.server.HttpHeaderUtil;
import karate.com.linecorp.armeria.server.HttpServer;
import karate.com.linecorp.armeria.server.HttpServerPipelineConfigurator;
import karate.com.linecorp.armeria.server.HttpServerUpgradeHandler;
import karate.com.linecorp.armeria.server.HttpStatusException;
import karate.com.linecorp.armeria.server.NettyHttp1Headers;
import karate.com.linecorp.armeria.server.NettyHttp1Request;
import karate.com.linecorp.armeria.server.Routed;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.ServerConfig;
import karate.com.linecorp.armeria.server.ServerHttp1ObjectEncoder;
import karate.com.linecorp.armeria.server.ServerHttp2ObjectEncoder;
import karate.com.linecorp.armeria.server.ServerHttpObjectEncoder;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceRouteUtil;
import karate.com.linecorp.armeria.server.StreamingDecodedHttpRequest;
import karate.com.linecorp.armeria.server.WebSocketServiceChannelHandler;
import karate.com.linecorp.armeria.server.websocket.WebSocketService;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelDuplexHandler;
import karate.io.netty.channel.ChannelHandler;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.handler.codec.DecoderResult;
import karate.io.netty.handler.codec.http.HttpContent;
import karate.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import karate.io.netty.handler.codec.http.HttpHeaderNames;
import karate.io.netty.handler.codec.http.HttpHeaders;
import karate.io.netty.handler.codec.http.HttpObject;
import karate.io.netty.handler.codec.http.HttpRequest;
import karate.io.netty.handler.codec.http.HttpUtil;
import karate.io.netty.handler.codec.http.HttpVersion;
import karate.io.netty.handler.codec.http.LastHttpContent;
import karate.io.netty.handler.codec.http.TooLongHttpHeaderException;
import karate.io.netty.handler.codec.http.TooLongHttpLineException;
import karate.io.netty.handler.codec.http2.Http2CodecUtil;
import karate.io.netty.handler.codec.http2.Http2Error;
import karate.io.netty.handler.codec.http2.Http2Settings;
import karate.io.netty.util.AsciiString;
import karate.io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http1RequestDecoder
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(Http1RequestDecoder.class);
    private static final Http2Settings DEFAULT_HTTP2_SETTINGS = new Http2Settings();
    private static final ResponseHeaders CONTINUE_RESPONSE = ResponseHeaders.of(HttpStatus.CONTINUE);
    private final ServerConfig cfg;
    private final AsciiString scheme;
    private SessionProtocol sessionProtocol;
    private final InboundTrafficController inboundTrafficController;
    private ServerHttpObjectEncoder encoder;
    private final HttpServer httpServer;
    @Nullable
    private DecodedHttpRequest req;
    private int receivedRequests;
    private boolean discarding;

    Http1RequestDecoder(ServerConfig cfg, Channel channel, AsciiString scheme, ServerHttp1ObjectEncoder encoder, HttpServer httpServer) {
        this.cfg = cfg;
        this.scheme = scheme;
        this.sessionProtocol = scheme == HttpServerPipelineConfigurator.SCHEME_HTTP ? SessionProtocol.H1C : SessionProtocol.H1;
        this.inboundTrafficController = InboundTrafficController.ofHttp1(channel);
        this.encoder = encoder;
        this.httpServer = httpServer;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.handlerAdded(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelActive(ctx);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        if (this.req instanceof HttpRequestWriter) {
            this.req.close(ClosedSessionException.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof HttpObject)) {
            ctx.fireChannelRead(msg);
            return;
        }
        KeepAliveHandler keepAliveHandler = this.encoder.keepAliveHandler();
        keepAliveHandler.onReadOrWrite();
        DecodedHttpRequest req = this.req;
        int id = req != null ? req.id() : (this.receivedRequests = this.receivedRequests + 1);
        try {
            if (this.discarding) {
                this.removeFromPipelineIfUpgraded(ctx, msg instanceof LastHttpContent);
                return;
            }
            if (req == null) {
                if (msg instanceof HttpRequest) {
                    boolean contentEmpty;
                    keepAliveHandler.increaseNumRequests();
                    HttpRequest nettyReq = (HttpRequest)msg;
                    if (!nettyReq.decoderResult().isSuccess()) {
                        Throwable cause = nettyReq.decoderResult().cause();
                        if (cause instanceof TooLongHttpLineException) {
                            this.fail(id, null, HttpStatus.REQUEST_URI_TOO_LONG, "Too Long URI", cause);
                        } else if (cause instanceof TooLongHttpHeaderException) {
                            this.fail(id, null, HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE, "Request header fields too large", cause);
                        } else {
                            this.fail(id, null, HttpStatus.BAD_REQUEST, "Decoder failure", cause);
                        }
                        return;
                    }
                    boolean hasInvalidExpectHeader = !this.handle100Continue(id, nettyReq);
                    String path = HttpHeaderUtil.maybeTransformAbsoluteUri(nettyReq.uri(), this.cfg.absoluteUriTransformer());
                    RequestTarget reqTarget = RequestTarget.forServer(path);
                    if (reqTarget == null) {
                        this.failWithInvalidRequestPath(id, null);
                        return;
                    }
                    assert (msg instanceof NettyHttp1Request);
                    boolean keepAlive = HttpUtil.isKeepAlive(nettyReq);
                    boolean transferEncodingChunked = HttpUtil.isTransferEncodingChunked(nettyReq);
                    NettyHttp1Headers nettyHttp1Headers = (NettyHttp1Headers)nettyReq.headers();
                    RequestHeaders headers = ArmeriaHttpUtil.toArmeria(ctx, nettyReq, nettyHttp1Headers.delegate(), this.cfg, this.scheme.toString(), reqTarget);
                    HttpMethod method = headers.method();
                    switch (method) {
                        case CONNECT: 
                        case UNKNOWN: {
                            this.fail(id, headers, HttpStatus.METHOD_NOT_ALLOWED, "Unsupported method", null);
                            return;
                        }
                    }
                    if (method != HttpMethod.OPTIONS && "*".equals(path)) {
                        this.failWithInvalidRequestPath(id, headers);
                        return;
                    }
                    String contentLengthStr = headers.get(HttpHeaderNames.CONTENT_LENGTH);
                    if (contentLengthStr != null) {
                        long contentLength;
                        try {
                            contentLength = Long.parseLong(contentLengthStr);
                        }
                        catch (NumberFormatException ignored) {
                            contentLength = -1L;
                        }
                        if (contentLength < 0L) {
                            this.fail(id, headers, HttpStatus.BAD_REQUEST, "Invalid content length", null);
                            return;
                        }
                        contentEmpty = contentLength == 0L;
                    } else {
                        contentEmpty = true;
                    }
                    if (hasInvalidExpectHeader) {
                        ctx.pipeline().fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
                        this.fail(id, headers, HttpStatus.EXPECTATION_FAILED, null, null);
                        return;
                    }
                    EventLoop eventLoop = ctx.channel().eventLoop();
                    RoutingContext routingCtx = ServiceRouteUtil.newRoutingContext(this.cfg, ctx.channel(), this.sessionProtocol, headers, reqTarget);
                    if (routingCtx.status().routeMustExist()) {
                        Routed<ServiceConfig> routed = routingCtx.virtualHost().findServiceConfig(routingCtx, true);
                        assert (routed.isPresent());
                        ServiceConfig serviceConfig = routingCtx.result().value();
                        if (WebSocketUtil.isHttp1WebSocketUpgradeRequest(headers)) {
                            if (serviceConfig.service().as(WebSocketService.class) == null) {
                                this.fail(id, headers, HttpStatus.BAD_REQUEST, "WebSocket upgrade requested but the service does not support it.", null);
                                return;
                            }
                            logger.trace("Received WebSocket upgrade headers: {}", (Object)headers);
                            if (this.httpServer.unfinishedRequests() > 0) {
                                this.fail(id, headers, HttpStatus.BAD_REQUEST, "WebSocket session cannot share the connection.", null);
                                return;
                            }
                            StreamingDecodedHttpRequest webSocketRequest = new StreamingDecodedHttpRequest(eventLoop, id, 1, headers, false, this.inboundTrafficController, serviceConfig.maxRequestLength(), routingCtx, ExchangeType.BIDI_STREAMING, System.nanoTime(), SystemInfo.currentTimeMicros(), true, false);
                            assert (this.encoder instanceof ServerHttp1ObjectEncoder);
                            ((ServerHttp1ObjectEncoder)this.encoder).webSocketUpgrading();
                            ChannelPipeline pipeline = ctx.pipeline();
                            pipeline.replace(this, null, (ChannelHandler)new WebSocketServiceChannelHandler(webSocketRequest, this.encoder, serviceConfig));
                            if (pipeline.get(HttpServerUpgradeHandler.class) != null) {
                                pipeline.remove(HttpServerUpgradeHandler.class);
                            }
                            this.cfg.serverMetrics().increasePendingHttp1Requests();
                            ctx.fireChannelRead(webSocketRequest);
                            return;
                        }
                    }
                    boolean endOfStream = contentEmpty && !transferEncodingChunked;
                    this.req = req = DecodedHttpRequest.of(endOfStream, eventLoop, id, 1, headers, keepAlive, this.inboundTrafficController, routingCtx);
                    this.cfg.serverMetrics().increasePendingHttp1Requests();
                    ctx.fireChannelRead(req);
                } else {
                    this.fail(id, null, HttpStatus.BAD_REQUEST, "Invalid decoder state", null);
                    return;
                }
            }
            boolean endOfStream = msg instanceof LastHttpContent;
            this.removeFromPipelineIfUpgraded(ctx, endOfStream);
            if (endOfStream && req instanceof EmptyContentDecodedHttpRequest) {
                this.req = null;
            } else if (msg instanceof HttpContent) {
                assert (req instanceof DecodedHttpRequestWriter);
                DecodedHttpRequestWriter decodedReq = (DecodedHttpRequestWriter)req;
                HttpContent content = (HttpContent)msg;
                DecoderResult decoderResult = content.decoderResult();
                if (!decoderResult.isSuccess()) {
                    this.fail(id, decodedReq.headers(), HttpStatus.BAD_REQUEST, "Decoder failure", null);
                    ProtocolViolationException cause = new ProtocolViolationException(decoderResult.cause());
                    decodedReq.close(HttpStatusException.of(HttpStatus.BAD_REQUEST, (Throwable)cause));
                    return;
                }
                ByteBuf data = content.content();
                int dataLength = data.readableBytes();
                if (dataLength != 0) {
                    decodedReq.increaseTransferredBytes(dataLength);
                    long maxContentLength = decodedReq.maxRequestLength();
                    long transferredLength = decodedReq.transferredBytes();
                    if (maxContentLength > 0L && transferredLength > maxContentLength) {
                        boolean shouldReset;
                        ContentTooLargeException cause = ContentTooLargeException.builder().maxContentLength(maxContentLength).contentLength(req.headers()).transferred(transferredLength).build();
                        this.discarding = true;
                        req = null;
                        if (this.encoder instanceof ServerHttp1ObjectEncoder) {
                            if (this.encoder.isResponseHeadersSent(id, 1)) {
                                ctx.channel().close();
                            } else {
                                keepAliveHandler.disconnectWhenFinished();
                            }
                            shouldReset = false;
                        } else {
                            shouldReset = !endOfStream;
                        }
                        HttpStatusException httpStatusException = HttpStatusException.of(HttpStatus.REQUEST_ENTITY_TOO_LARGE, (Throwable)cause);
                        decodedReq.setShouldResetOnlyIfRemoteIsOpen(shouldReset);
                        decodedReq.abortResponse(httpStatusException, true);
                        return;
                    }
                    if (decodedReq.isOpen()) {
                        decodedReq.write(HttpData.wrap(data.retain()));
                    }
                }
                if (endOfStream) {
                    HttpHeaders trailingHeaders = ((LastHttpContent)msg).trailingHeaders();
                    if (!trailingHeaders.isEmpty()) {
                        decodedReq.write(ArmeriaHttpUtil.toArmeria(trailingHeaders));
                    }
                    decodedReq.close();
                    this.req = null;
                }
            }
        }
        catch (URISyntaxException e) {
            if (req != null) {
                this.fail(id, req.headers(), HttpStatus.BAD_REQUEST, "Invalid request path", e);
                req.close(HttpStatusException.of(HttpStatus.BAD_REQUEST, (Throwable)e));
            } else {
                this.fail(id, null, HttpStatus.BAD_REQUEST, "Invalid request path", e);
            }
        }
        catch (Throwable t) {
            if (req != null) {
                this.fail(id, req.headers(), HttpStatus.INTERNAL_SERVER_ERROR, null, t);
                req.close(HttpStatusException.of(HttpStatus.INTERNAL_SERVER_ERROR, t));
            } else {
                this.fail(id, null, HttpStatus.INTERNAL_SERVER_ERROR, null, t);
                logger.warn("Unexpected exception:", t);
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    private void removeFromPipelineIfUpgraded(ChannelHandlerContext ctx, boolean endOfStream) {
        if (endOfStream && this.encoder instanceof ServerHttp2ObjectEncoder) {
            ctx.pipeline().remove(this);
        }
    }

    private boolean handle100Continue(int id, HttpRequest nettyReq) {
        HttpHeaders nettyHeaders = nettyReq.headers();
        if (nettyReq.protocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return true;
        }
        String expectValue = nettyHeaders.get(HttpHeaderNames.EXPECT);
        if (expectValue == null) {
            return true;
        }
        if (!Ascii.equalsIgnoreCase("100-continue", expectValue)) {
            return false;
        }
        this.encoder.writeHeaders(id, 1, CONTINUE_RESPONSE, false, HttpMethod.valueOf(nettyReq.method().name()));
        nettyHeaders.remove(HttpHeaderNames.EXPECT);
        return true;
    }

    private void failWithInvalidRequestPath(int id, @Nullable RequestHeaders headers) {
        this.fail(id, headers, HttpStatus.BAD_REQUEST, "Invalid request path", null);
    }

    private void fail(int id, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String message, @Nullable Throwable cause) {
        if (this.encoder.isResponseHeadersSent(id, 1)) {
            this.encoder.writeReset(id, 1, Http2Error.PROTOCOL_ERROR, false);
        } else {
            this.discarding = true;
            this.req = null;
            this.encoder.writeErrorResponse(id, 1, this.cfg.defaultVirtualHost().fallbackServiceConfig(), headers, status, message, cause);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            ChannelPipeline pipeline = ctx.pipeline();
            ChannelHandlerContext connectionHandlerCtx = pipeline.context(Http2ServerConnectionHandler.class);
            Http2ServerConnectionHandler connectionHandler = (Http2ServerConnectionHandler)connectionHandlerCtx.handler();
            this.encoder.close();
            this.encoder = connectionHandler.getOrCreateResponseEncoder(connectionHandlerCtx);
            this.sessionProtocol = SessionProtocol.H2C;
            ctx.fireChannelRead(DEFAULT_HTTP2_SETTINGS);
            HttpRequest nettyReq = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            nettyReq.headers().remove(HttpHeaderNames.CONNECTION);
            nettyReq.headers().remove(HttpHeaderNames.UPGRADE);
            nettyReq.headers().remove(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
            if (logger.isDebugEnabled()) {
                logger.debug("{} Handling the pre-upgrade request ({}): {} {} {}", new Object[]{ctx.channel(), ((HttpServerUpgradeHandler.UpgradeEvent)evt).protocol(), nettyReq.method(), nettyReq.uri(), nettyReq.protocolVersion()});
            }
            this.channelRead(ctx, nettyReq);
            return;
        }
        if (evt instanceof InitiateConnectionShutdown && this.encoder instanceof ServerHttp1ObjectEncoder) {
            this.encoder.keepAliveHandler().disconnectWhenFinished();
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void maybeInitializeKeepAliveHandler(ChannelHandlerContext ctx) {
        KeepAliveHandler keepAliveHandler = this.encoder.keepAliveHandler();
        if (!(keepAliveHandler instanceof NoopKeepAliveHandler) && ctx.channel().isActive() && ctx.channel().isRegistered()) {
            keepAliveHandler.initialize(ctx);
        }
    }
}

