/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandler;
import karate.com.linecorp.armeria.internal.common.GracefulConnectionShutdownHandler;
import karate.com.linecorp.armeria.internal.common.InitiateConnectionShutdown;
import karate.com.linecorp.armeria.internal.common.KeepAliveHandler;
import karate.com.linecorp.armeria.internal.common.KeepAliveHandlerUtil;
import karate.com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import karate.com.linecorp.armeria.server.GracefulShutdownSupport;
import karate.com.linecorp.armeria.server.Http2RequestDecoder;
import karate.com.linecorp.armeria.server.Http2ServerKeepAliveHandler;
import karate.com.linecorp.armeria.server.ServerConfig;
import karate.com.linecorp.armeria.server.ServerHttp2ObjectEncoder;
import karate.io.micrometer.core.instrument.Timer;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelPromise;
import karate.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import karate.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import karate.io.netty.handler.codec.http2.Http2Settings;
import karate.io.netty.util.AsciiString;

final class Http2ServerConnectionHandler
extends AbstractHttp2ConnectionHandler {
    private final ServerConfig cfg;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private final Http2RequestDecoder requestDecoder;
    @Nullable
    private ServerHttp2ObjectEncoder responseEncoder;
    private final Http2GracefulConnectionShutdownHandler gracefulConnectionShutdownHandler;

    Http2ServerConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, Channel channel, ServerConfig cfg, Timer keepAliveTimer, GracefulShutdownSupport gracefulShutdownSupport, AsciiString scheme) {
        super(decoder, encoder, initialSettings, Http2ServerConnectionHandler.newKeepAliveHandler(encoder, channel, cfg, keepAliveTimer));
        this.cfg = cfg;
        this.gracefulShutdownSupport = gracefulShutdownSupport;
        this.gracefulConnectionShutdownHandler = new Http2GracefulConnectionShutdownHandler(cfg.connectionDrainDurationMicros());
        this.requestDecoder = new Http2RequestDecoder(cfg, channel, scheme, this.keepAliveHandler());
        this.connection().addListener(this.requestDecoder);
        this.decoder().frameListener(this.requestDecoder);
    }

    private static KeepAliveHandler newKeepAliveHandler(Http2ConnectionEncoder encoder, Channel channel, ServerConfig cfg, Timer keepAliveTimer) {
        int maxNumRequestsPerConnection;
        long maxConnectionAgeMillis;
        long idleTimeoutMillis = cfg.idleTimeoutMillis();
        boolean keepAliveOnPing = cfg.keepAliveOnPing();
        long pingIntervalMillis = cfg.pingIntervalMillis();
        boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis = cfg.maxConnectionAgeMillis(), maxNumRequestsPerConnection = cfg.maxNumRequestsPerConnection());
        if (!needsKeepAliveHandler) {
            return new NoopKeepAliveHandler();
        }
        return new Http2ServerKeepAliveHandler(channel, encoder.frameWriter(), keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection, keepAliveOnPing);
    }

    ServerHttp2ObjectEncoder getOrCreateResponseEncoder(ChannelHandlerContext connectionHandlerCtx) {
        if (this.responseEncoder == null) {
            assert (connectionHandlerCtx.handler() == this);
            this.responseEncoder = new ServerHttp2ObjectEncoder(connectionHandlerCtx, this);
            this.requestDecoder.initEncoder(this.responseEncoder);
        }
        return this.responseEncoder;
    }

    @Override
    protected boolean needsImmediateDisconnection() {
        return this.gracefulShutdownSupport.isShuttingDown() || this.requestDecoder.goAwayHandler().receivedErrorGoAway() || this.keepAliveHandler().isClosing();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cancelScheduledTasks();
        super.channelInactive(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelActive(ctx);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelRegistered(ctx);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.handlerAdded(ctx);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.cancelScheduledTasks();
        super.handlerRemoved0(ctx);
    }

    private void maybeInitializeKeepAliveHandler(ChannelHandlerContext ctx) {
        Channel channel;
        KeepAliveHandler keepAliveHandler = this.keepAliveHandler();
        if (!(keepAliveHandler instanceof NoopKeepAliveHandler) && (channel = ctx.channel()).isActive() && channel.isRegistered()) {
            keepAliveHandler.initialize(ctx);
        }
    }

    private void cancelScheduledTasks() {
        this.gracefulConnectionShutdownHandler.cancel();
        this.keepAliveHandler().destroy();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof InitiateConnectionShutdown) {
            this.setGoAwayDebugMessage("app-requested");
            this.gracefulConnectionShutdownHandler.handleInitiateConnectionShutdown(ctx, (InitiateConnectionShutdown)evt);
            return;
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.keepAliveHandler().needsDisconnection()) {
            this.setGoAwayDebugMessage("max-age");
        }
        this.gracefulConnectionShutdownHandler.start(ctx, promise);
    }

    private final class Http2GracefulConnectionShutdownHandler
    extends GracefulConnectionShutdownHandler {
        Http2GracefulConnectionShutdownHandler(long drainDurationMicros) {
            super(drainDurationMicros);
        }

        @Override
        public void onDrainStart(ChannelHandlerContext ctx) {
            Http2ServerConnectionHandler.this.goAway(ctx, Integer.MAX_VALUE);
            ctx.flush();
        }

        @Override
        public void onDrainEnd(ChannelHandlerContext ctx) throws Exception {
            Http2ServerConnectionHandler.super.close(ctx, ctx.newPromise());
            Http2ServerConnectionHandler.this.cancelScheduledTasks();
        }
    }
}

