/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import karate.com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandlerBuilder;
import karate.com.linecorp.armeria.server.GracefulShutdownSupport;
import karate.com.linecorp.armeria.server.Http2ServerConnectionHandler;
import karate.com.linecorp.armeria.server.ServerConfig;
import karate.io.micrometer.core.instrument.Timer;
import karate.io.netty.channel.Channel;
import karate.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import karate.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import karate.io.netty.handler.codec.http2.Http2Settings;
import karate.io.netty.util.AsciiString;

final class Http2ServerConnectionHandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2ServerConnectionHandler, Http2ServerConnectionHandlerBuilder> {
    private final ServerConfig config;
    private final Timer keepAliveTimer;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private final AsciiString scheme;

    Http2ServerConnectionHandlerBuilder(Channel ch, ServerConfig config, Timer keepAliveTimer, GracefulShutdownSupport gracefulShutdownSupport, AsciiString scheme) {
        super(ch);
        this.config = config;
        this.keepAliveTimer = keepAliveTimer;
        this.gracefulShutdownSupport = gracefulShutdownSupport;
        this.scheme = scheme;
        this.gracefulShutdownTimeoutMillis(-1L);
        this.decoderEnforceMaxRstFramesPerWindow(config.http2MaxResetFramesPerWindow(), config.http2MaxResetFramesWindowSeconds());
    }

    @Override
    protected Http2ServerConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        return new Http2ServerConnectionHandler(decoder, encoder, initialSettings, this.channel(), this.config, this.keepAliveTimer, this.gracefulShutdownSupport, this.scheme);
    }
}

