/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.Objects;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.annotation.Nullable;

public final class HttpStatusException
extends RuntimeException {
    private static final HttpStatusException[] EXCEPTIONS = new HttpStatusException[1000];
    private static final long serialVersionUID = 3341744805097308847L;
    private final HttpStatus httpStatus;

    public static HttpStatusException of(int statusCode) {
        return HttpStatusException.of(HttpStatus.valueOf(statusCode));
    }

    public static HttpStatusException of(int statusCode, Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        return HttpStatusException.of(HttpStatus.valueOf(statusCode), cause);
    }

    public static HttpStatusException of(HttpStatus status) {
        return HttpStatusException.of0(Objects.requireNonNull(status, "status"), null);
    }

    public static HttpStatusException of(HttpStatus status, Throwable cause) {
        return HttpStatusException.of0(Objects.requireNonNull(status, "status"), Objects.requireNonNull(cause, "cause"));
    }

    private static HttpStatusException of0(HttpStatus status, @Nullable Throwable cause) {
        boolean sampled = Flags.verboseExceptionSampler().isSampled(HttpStatusException.class);
        if (sampled || cause != null) {
            return new HttpStatusException(status, sampled, cause);
        }
        int statusCode = status.code();
        if (statusCode >= 0 && statusCode < 1000) {
            return EXCEPTIONS[statusCode];
        }
        return new HttpStatusException(HttpStatus.valueOf(statusCode), false, null);
    }

    private HttpStatusException(HttpStatus httpStatus, boolean withStackTrace, @Nullable Throwable cause) {
        super(Objects.requireNonNull(httpStatus, "httpStatus").toString(), cause, withStackTrace, withStackTrace);
        this.httpStatus = httpStatus;
    }

    public HttpStatus httpStatus() {
        return this.httpStatus;
    }

    static {
        for (int i = 0; i < EXCEPTIONS.length; ++i) {
            HttpStatusException.EXCEPTIONS[i] = new HttpStatusException(HttpStatus.valueOf(i), false, null);
        }
    }
}

