/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.TargetLengthBasedClassNameAbbreviator;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.server.ServiceNaming;
import karate.com.linecorp.armeria.server.ServiceRequestContext;

final class LengthBasedServiceNaming
implements ServiceNaming {
    private final TargetLengthBasedClassNameAbbreviator abbreviator;
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    static LengthBasedServiceNaming of(int shortenedServiceNameLength) {
        return new LengthBasedServiceNaming(shortenedServiceNameLength);
    }

    private LengthBasedServiceNaming(int shortenedServiceNameLength) {
        Preconditions.checkArgument(shortenedServiceNameLength >= 0, "value: %s (expected >= 0)", shortenedServiceNameLength);
        this.abbreviator = new TargetLengthBasedClassNameAbbreviator(shortenedServiceNameLength);
    }

    @Override
    @Nullable
    public String serviceName(ServiceRequestContext ctx) {
        String fullTypeName = ServiceNaming.fullTypeName().serviceName(ctx);
        return fullTypeName != null ? this.abbreviate(fullTypeName) : null;
    }

    private String abbreviate(String serviceName) {
        String abbreviation = (String)this.cache.get(serviceName);
        if (abbreviation != null) {
            return abbreviation;
        }
        return this.cache.computeIfAbsent(serviceName, this.abbreviator::abbreviate);
    }
}

